% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_mir_terms.R
\name{compare_mir_terms_scatter}
\alias{compare_mir_terms_scatter}
\title{Compare shared terms associated with a miRNA name}
\usage{
compare_mir_terms_scatter(
  df,
  mir,
  top = 1000,
  token = "words",
  ...,
  topic = NULL,
  stopwords = stopwords_miretrieve,
  stopwords_ngram = TRUE,
  html = TRUE,
  colour.point = "red",
  colour.term = "black",
  col.mir = miRNA,
  col.abstract = Abstract,
  col.topic = Topic,
  col.pmid = PMID,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing miRNA names, abstracts, topics, and PubMed-IDs.}

\item{mir}{String. miRNA name of interest.}

\item{top}{Integer. Number of top terms to plot.}

\item{token}{String. Specifies how abstracts shall be split up. Taken from
\code{unnest_tokens()} in the \pkg{tidytext} package:
"Unit for tokenizing, or a custom tokenizing function. Built-in options are
"words" (default), "characters", "character_shingles", "ngrams", "skip_ngrams",
"sentences", "lines", "paragraphs", "regex",
(...),
and "ptb" (Penn Treebank). If a function, should take a character vector and
return a list of character vectors of the same length."}

\item{...}{Additional arguments for tokenization, if necessary.}

\item{topic}{Character vector. Optional. Specifies which topics to plot.
Must have length two.
If \code{topic = NULL}, all topics in \code{df} are plotted.}

\item{stopwords}{Data frame containing stop words.}

\item{stopwords_ngram}{Boolean. Specifies if stop words shall be removed
from abstracts when using ngrams. Only applied when \code{token = 'ngrams'}.}

\item{html}{Boolean. Specifies if plot is returned as an HTML-widget
or static.}

\item{colour.point}{String. Colour of points for scatter plot.}

\item{colour.term}{String. Colour of terms for scatter plot.}

\item{col.mir}{Symbol. Column containing miRNAs.}

\item{col.abstract}{Symbol. Column containing abstracts.}

\item{col.topic}{Symbol. Column containing topics names.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}

\item{title}{String. Plot title.}
}
\value{
Scatter plot comparing shared terms of a miRNA between two topics.
}
\description{
Compare shared terms associated with a miRNA name over two topics.
}
\details{
Compare shared terms associated with a miRNA name over two topics. These terms are displayed
as a scatter plot, which is either interactive as an HTML-widget, or static. This
is regulated via the \code{html} argument.
miRNA names and topics must be in a data frame \code{df}, while terms are taken
from abstracts contained in \code{df}.
Number of top terms to choose is regulated by \code{top}. Terms are
evaluated as their raw count and plotted on a log10-scale.
\code{compare_mir_terms_scatter()} is based on the tools available in the
\pkg{tidytext} package.
The term-plot is greatly inspired by
“tidytext: Text Mining and Analysis Using Tidy Data Principles in R.” by
Silge and Robinson.
}
\references{
Silge, Julia, and David Robinson. 2016.
“tidytext: Text Mining and Analysis Using Tidy Data Principles in R.”
JOSS 1 (3). The Open Journal. https://doi.org/10.21105/joss.00037.
}
\seealso{
\code{\link[=compare_mir_terms]{compare_mir_terms()}}, \code{\link[=compare_mir_terms_log2]{compare_mir_terms_log2()}}

Other compare functions: 
\code{\link{compare_mir_count_log2}()},
\code{\link{compare_mir_count_unique}()},
\code{\link{compare_mir_count}()},
\code{\link{compare_mir_terms_log2}()},
\code{\link{compare_mir_terms_unique}()},
\code{\link{compare_mir_terms}()}
}
\concept{compare functions}
