% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pmid.R
\name{get_pmid}
\alias{get_pmid}
\title{Get PubMed-IDs of a data frame}
\usage{
get_pmid(df, col.pmid = PMID, copy = TRUE)
}
\arguments{
\item{df}{Data frame containing PubMed-IDs.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}

\item{copy}{Boolean. If \code{copy = FALSE}, \code{get_pmid()} returns a character
vector, containing PubMed-IDs. If \code{copy = TRUE}, \code{get_pmid()} copies
PubMed-IDs to clipboard.}
}
\value{
Copy to clipboard or character vector.
If \code{copy = TRUE}, \code{get_pmid()} copies
PubMed-IDs to clipboard.
If \code{copy = FALSE}, \code{get_pmid()} returns a character
vector, containing PubMed-IDs.
}
\description{
Get PubMed-IDs of a data frame.
}
\details{
Get PubMed-IDs of a data frame. \code{get_pmid} returns either a character
vector, containing PubMed-IDs, or copies PubMed-IDs to clipboard. If PubMed-IDs
are copied to the clipboard, they can be used e.g. to search for abstracts on
PubMed.
}
\seealso{
Other get functions: 
\code{\link{get_distinct_mir_df}()},
\code{\link{get_distinct_mir_vec}()},
\code{\link{get_mir}()},
\code{\link{get_shared_mir_df}()},
\code{\link{get_shared_mir_vec}()},
\code{\link{get_snp}()}
}
\concept{get functions}
