\name{.pmm.match}
\alias{.pmm.match}
\title{Finds an imputed value from matches in the predictive metric}
\usage{
  .pmm.match(z, yhat = yhat, y = y, donors = 3, ...)
}
\arguments{
  \item{z}{A scalar containing the predicted value for the
  current case to be imputed.}

  \item{yhat}{A vector containing the predicted values for
  all cases with an observed outcome.}

  \item{y}{A vector of \code{length(yhat)} elements
  containing the observed outcome}

  \item{donors}{The size of the donor pool among which a
  draw is made. The default is \code{donors = 3}. Setting
  \code{donors = 1} always selects the closest match.
  Values between 3 and 10 provide the best results.}

  \item{\dots}{Other parameters (not used).}
}
\value{
  A scalar containing the observed value of the selected
  donor.
}
\description{
  This function finds matches among the observed data in
  the predictive mean metric. It selects the \code{donors}
  closest matches, randomly samples one of the donors, and
  returns the observed value of the match.
}
\author{
  Stef van Buuren
}
\references{
  Schenker N \& Taylor JMG (1996) Partially parametric
  techniques for multiple imputation. \emph{Computational
  Statistics and Data Analysis}, 22, 425-446.

  Little RJA (1988) Missing-data adjustments in large
  surveys (with discussion). \emph{Journal of Business
  Economics and Statistics}, 6, 287-301.
}

