% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity.R
\name{ma_similarity}
\alias{ma_similarity}
\title{Similarity API}
\usage{
ma_similarity(s1, s2, method = "GET", model = "latest", key = NULL,
  ...)
}
\arguments{
\item{s1, s2}{(character) strings 1 and 2. required}

\item{method}{(character) one of GET (default) or POST}

\item{model}{(character) Name of the model that you wish to query. One of
'latest' or 'beta-2015'. Default: latest}

\item{key}{(character) microsoft academic API key, see the \code{Authentication}
section in \link{microdemic-package}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
a single value representing the cosine similarity of the text inputs
of s1 and s2. The output is represented by a floating point between -1.0
and +1.0. The similarity API evaluates the strings base on their academic
concepts, with +1.0 being the most similar and -1.0 being the least similar.
}
\description{
Similarity API
}
\examples{
\dontrun{
s1 <- "Using complementary priors, we derive a fast greedy algorithm that
can learn deep directed belief networks one layer at a time, provided the
top two layers form an undirected associative memory"

s2 <- "Deepneural nets with a large number of parameters are very powerful
machine learning systems. However, overfitting is a serious problem in
such networks"

ma_similarity(s1, s2)

ma_similarity(s1, s2, method = "POST")
}
}
