% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{dmig_laplacian}
\alias{dmig_laplacian}
\title{Laplacian of the MIG density with respect to the data}
\usage{
dmig_laplacian(x, xi, Omega, beta, scale = TRUE)
}
\arguments{
\item{x}{\code{n} by \code{d} matrix of quantiles}

\item{xi}{\code{d} vector of location parameters \eqn{\boldsymbol{\xi}}, giving the expected value}

\item{Omega}{\code{d} by \code{d} positive definite scale matrix \eqn{\boldsymbol{\Omega}}}

\item{beta}{\code{d} vector \eqn{\boldsymbol{\beta}} defining the half-space through \eqn{\boldsymbol{\beta}^{\top}\boldsymbol{\xi}>0}}
}
\value{
an \code{n} vector
}
\description{
Computes the sum of second derivatives of the multivariate
inverse Gaussian density with respect to the data argument
\code{x}. The function is vectorized for more efficiency.
}
\keyword{internal}
