#' Lifetime migration totals for states and zones in the Indian 1901 to 1931
#'
#' Lifetime migration (stock) totals from India
#'
#' @format Data frame with 164 rows and 7 columns:
#' \describe{
#'   \item{zone}{Zone of state. In some cases the state and zone are the same entity}
#'   \item{state}{Indian state}
#'   \item{sex}{Migrant sex}
#'   \item{in_migrants}{In-migrant total based on birthplace}
#'   \item{out_migrants}{Out-migrant total based on birthplace}
#'   \item{net_migrants}{Net migrant total based on birthplace}
#' }
#' @source  Zachariah, K. C. (1964). A Historical Study of Internal Migration in the Indian Sub-Continent 1901-1931. (Vol. 19). Asia Publishing House.
#' 
#' Scraped from \url{https://archive.org/details/in.ernet.dli.2015.130424/page/n73/mode/2up}
"indian_sub"