% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{regression}
\alias{regression}
\alias{network_reg}
\alias{summary.netlm}
\alias{print.summary.netlm}
\title{Linear regression for network data}
\usage{
network_reg(formula, data, ...)

\method{summary}{netlm}(object, reps = 1000, ...)

\method{print}{summary.netlm}(
  x,
  digits = max(3, getOption("digits") - 3),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{formula}{A formula describing the relationship being tested.}

\item{data}{A named list of matrices, graphs, or a tidygraph object.}

\item{...}{Arguments passed on to \code{lm()}.}

\item{object}{an object of class "netlm", usually as a result of a call to
\code{network_reg()}.}

\item{reps}{Integer indicating the number of draws to use for quantile
estimation. (Relevant to the null hypothesis test only - the analysis
itself is unaffected by this parameter.)
Note that, as for all Monte Carlo procedures, convergence is slower for more
extreme quantiles.
By default, reps=1000.}

\item{x}{an object of class "summary.netlm", usually, a result of a call to
\code{summary.netlm()}.}

\item{digits}{the number of significant digits to use when printing.}

\item{signif.stars}{logical. If TRUE, ‘significance stars’ are printed for
each coefficient.}
}
\description{
This function extends the multiple regression quadratic assignment procedure
(MRQAP) of network linear model to two mode networks.
It also works with combined graph/network objects by constructing the
various dependent and independent matrices for the user.
Lastly, because it relies on an object that contains all this information
it can offer a more informative formula-based system for specifying the model.
}
\examples{
messages <- mutate_edges(ison_eies, 
  generate_random(ison_eies), attr_name = "random")
model1 <- network_reg(weight ~ random + 
  same(Discipline) + same(Citations), messages)
summary(model1, reps = 200) # increase reps for publication
}
