% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition.R
\name{get_partition_indices}
\alias{get_partition_indices}
\title{Select indices to partition the data into training & testing sets.}
\usage{
get_partition_indices(outcomes, training_frac = 0.8, groups = NULL)
}
\arguments{
\item{outcomes}{vector of outcomes}

\item{training_frac}{max fraction of data for the training set(default: 0.8)}

\item{groups}{vector of groups. length must match the number of rows in the dataset. (default: NULL)}
}
\value{
Vector of row indices for the training set.
}
\description{
Use this function to get the row indices for the training set.
}
\details{
If \code{groups} is \code{NULL}, uses \link[caret]{createDataPartition}.
Otherwise, uses \code{create_grouped_data_partition()}.

Set the seed prior to calling this function if you would like your data
partitions to be reproducible (recommended).
}
\examples{
training_inds <- get_partition_indices(otu_mini_bin$dx)
train_data <- otu_mini_bin[training_inds, ]
test_data <- otu_mini_bin[-training_inds, ]
}
\author{
Kelly Sovacool, {sovacool@umich.edu}
}
