
### Transfer data to MIM

toMIM <- function(data) UseMethod("toMIM", data)

toMIM.default <- function(data){
  gmd <- as.gmData(data)
  toMIM(gmd)
}

toMIM.gmData <- function(data){
  do <- dataOrigin(data)   ##mim.cmd("clear; clear output")
  if (is.null(do))
    .varspec.toMIM(data,text="# gmData without observations")
  else
    switch(do,
           "data.frame"      = {.dataframe.to.mim(data)         },
           "table"           = {.table.to.mim(data)             },
           "cellCounts"      = {.cellCounts.to.mim(data)        },
           "empCov"          = {.empCov.to.mim(data)            }
           )
}




.dataframe.to.mim <- function(data,file="mimR_df2mim.txt"){

  nt <- data

  varspec  <- .findVarspec(nt)

  short    <- paste("Read", paste(shortNames(nt), collapse=' '))

  mdata <- observations(nt)
  for (j in 1:ncol(mdata))
    mdata[,j] <- as.numeric(mdata[,j])
  datastr  <- sapply(as.vector(t(mdata)), .float.to.string, n.digits=3, width=2)
    
  mygetwd <- function()gsub("/","\\\\",getwd())  ## tempdir()
  file <- paste(mygetwd(),"\\",file,sep='')
  
  tmp <- proc.time()
  write("%\n% DATA FILE AUTOMATICALLY GENERATED BY mimR", file, append=FALSE)
  write(paste("% TIME:", date(),  "%"), file, append=TRUE)
  write(paste("% FILE:", file,  "\n%"), file, append=TRUE)

  lapply(varspec, write, file,append=TRUE)
  write(short, file, append=TRUE)  
  write(datastr, file, append=TRUE, ncolumns=20)
  write("!", file, append=TRUE)

  mim.cmd(paste("clear; clear output;"))
  str  <- paste("input", file, ";", sep=' ');
  mim.cmd(str, look.nice=FALSE);  
  return(file)
}


.table.to.mim <- function(data){
  .varspec.toMIM(data,text=c("#", "# Sufficient statistics from 'table'","#"))
  
  ss <- shortNames(data)
  ss <- ss[length(ss):1]
  s  <- paste("Statread", paste(ss, collapse=''))
  mim.cmd(s)
  res <- as.vector(observations(data))
  lapply(.partition.mim.input(res),mim.cmd)
  mim.cmd("!", look.nice=FALSE)    
}


.cellCounts.to.mim <- function(from){
  mim.cmd("# clear"); mim.cmd("clear")
  d           <- observations(from)
  dim(d)      <- rev(sapply(valueLabels(from), length))
  dimnames(d) <- rev(valueLabels(from))
  d           <- as.table(d)
  toMIM(d)  
}



.empCov.to.mim <- function(from){
  mim.cmd("# clear"); mim.cmd("clear")

  .varspec.toMIM(from,text=c("#", "# Sufficient statistics from 'empCov'","#"))
  
  res<- observations(from)
  xx<-c(res$counts, res$mean, res$S[upper.tri(res$S, diag=TRUE)])

  s  <- paste("Statread", paste(shortNames(from), collapse=''))
  mim.cmd(s)

  lapply(.partition.mim.input(xx),mim.cmd)
  mim.cmd("!", look.nice=FALSE)    
}



# .momentstats.to.mim <- function(data){
#   vs <-.namesTable.to.varspec(data)
#   a<- lapply(vs, paste)
#   a<- a[lapply(a,length)>0]
#   lapply(a, mim.cmd)
#   res<- t(.getdata(observations(data)))

#   s  <- paste("Statread", paste(data$letter, collapse=''))
#   mim.cmd(s)
#   lapply(.partition.mim.input(res),mim.cmd)
#   mim.cmd("!", look.nice=FALSE)    
# }



# .getdata <- function(x){  ## Bruges kun i momentstats.to.mim
#   switch(class(x)[2],
#          'mixed'={
#            if (is.null(x$cmc))
#              t(mapply(function(x,y,z) {c(x,y, z[lower.tri(z, diag=TRUE)])}, 
#                     x$counts, x$means, x$covariances))
#            else
#              do.call("rbind",
#                      lapply(x$cmc,
#                             function(z)c(z[[3]],z[[2]],
#                                          z[[1]][lower.tri(z[[1]], diag=TRUE)])))
#          },
#          'continuous'={
#            if (is.null(x$cmc))
#              c(x$counts, x$means, x$covariances[lower.tri(x$covariances, diag=TRUE)])
#            else{
#              z <- x$cmc
#              c(z[[3]],z[[2]],z[[1]][lower.tri(z[[1]], diag=TRUE)])
#            }
  
#          },
#          'discrete'={
#            x$counts
#          })
# }






# .namesTable.to.varspec <- function(nt){
#   var.spec <-
#     paste(paste("Fact", paste(nt$letter[nt$factor==TRUE],nt$levels[nt$factor==TRUE],
#                               collapse=' ')), ";",
#           paste("Cont", paste(nt$letter[nt$factor==FALSE],collapse=' '))  )
  
#   lab.spec <- paste("Labels", nt$letter,
#                     gsub(' ','',paste('\"',nt$name,'\"'))     )

#   vallab.list <- NULL

#   factor.letter <- nt$letter[nt$factor==TRUE]
#   factor.levels <- nt$levels[nt$factor==TRUE]
#   if (length(factor.letter)>0){
#     vl <- attr(nt, "vallabels")
#     for (j in 1:length(factor.letter)){
#       x1 <- paste("ValLabel", factor.letter[j])
#       x2 <- paste(1:factor.levels[j], gsub(' ','',paste('\"',vl[[j]],'\"')))
#       x <- paste(x1,paste(x2,collapse=' '))
#       vallab.list <- c(vallab.list, x)
#     }
#   }
#   value<-list("var.spec"=var.spec, "lab.spec"=lab.spec,"vallab.spec"=vallab.list)
# }



###
### local to toMIMxxxx.R
###

.partition.mim.input <- function(input,token=NULL){    
  curr     <- input
  n.char   <- 50 
  res <- NULL
    while(sum(nchar(curr))>n.char){
    cs <- cumsum(nchar(curr)+1)
    res <- c(res, paste(curr[cs<=n.char], collapse=' '))
    curr <- curr[!(cs<=n.char)]
  }
  value <- c(res, paste(curr, collapse=' '))
  return(value)
}

.float.to.string <-
  function(num.vec,n.digits=6,width=9, preserve.int=TRUE){
    if (is.na(num.vec) || is.null(num.vec))
      return("*")
    else{
      if ((num.vec-round(num.vec))==0)
        return( sprintf("%g",num.vec) )
      else
        return( sprintf("%.5f",num.vec) ) 
    }
  }


# toMIM.data.frame <- function(data){    
#   gmd <- as.gmData(data)
#   toMIM(gmd)
# }

# toMIM.table <- function(data){         
#   gmd <- as.gmData(data)
#   toMIM(gmd)
# }

# toMIM.momentstats <- function(data){   
#   gmd <- as.gmData(data)
#   toMIM(gmd)
# }






# .dataframe.to.mim.BAK <- function(data,file="mimR_df2mim.txt"){

#   ##mygetwd <- function()gsub("/","\\\\",getwd())
#   mygetwd <- function()gsub("/","\\\\",tempdir())
  
#   nt <- as.data.frame(data)
#   vs <- .namesTable.to.varspec(nt)

#   mdata <- observations(data)
#   for (j in 1:ncol(mdata))
#     mdata[,j] <- as.numeric(mdata[,j])
#   str4     <- unlist( lapply( as.vector(t(mdata)), .float.to.string, n.digits=3,
#                              width=2))

#   var.letter <- names2letters(names(mdata),nt)

#   file <- paste(mygetwd(),"\\",file,sep='')
  
#   tmp <- proc.time()
#   ##cat("Writing MIM data file (in working dir)", specfile,"... ")
#   write("%\n% DATA FILE AUTOMATICALLY GENERATED BY mimR", file, append=FALSE)
#   write(paste("% TIME:", date(),  "%"), file, append=TRUE)
#   write(paste("% FILE:", file,  "\n%"), file, append=TRUE)

#   lapply(vs, write, file,append=TRUE)
#   write(paste("Read", paste(var.letter, collapse=' ')), file, append=TRUE)  

#   write(str4, file, append=TRUE, ncolumns=20)
#   write("!", file, append=TRUE)

#   mim.cmd(paste("clear; clear output;"))
#   str  <- paste("input", file, ";", sep=' ');
#   mim.cmd(str, look.nice=FALSE);  
#   ##Sys.sleep(2)
#   ##mim.cmd("pr d");
#   ##cat("Time taken:", (proc.time()-tmp)[3],"\n")
#   return(file)
# }


# primitiveData2MIM <- function(from) UseMethod("primitiveData2MIM")

# primitiveData2MIM.data.frame <- function(from){
#   .dataframe.to.mim(data) 
# }

# primitiveData2MIM.table <- function(from){
#   .table.to.mim(data) 
# }

# primitiveData2MIM.momentstats <- function(from){
#   .momentstats.to.mim(data) 
# }
