% Generated by roxygen2 (4.0.1): do not edit by hand
\name{makeDepGraph}
\alias{makeDepGraph}
\title{Create dependency graph from available packages.}
\usage{
makeDepGraph(pkg, availPkgs, repos = getOption("repos"), type = "source",
  suggests = TRUE, enhances = FALSE, includeBasePkgs = FALSE, ...)
}
\arguments{
\item{pkg}{Character vector of packages.}

\item{availPkgs}{Vector of available packages.  Defaults to reading this list from CRAN, using \code{\link{available.packages}}}

\item{repos}{URL(s) of the 'contrib' sections of the repositories. Passed to \code{\link{available.packages}}}

\item{type}{Possible values are (currently) "source", "mac.binary" and "win.binary": the binary types can be listed and downloaded but not installed on other platforms.  Passed to \code{\link{download.packages}}.}

\item{suggests}{If TRUE, retrieves Suggests dependencies (non-recursively)}

\item{enhances}{If TRUE, retrieves Enhances dependencies (non-recursively)}

\item{includeBasePkgs}{If TRUE, include base R packages in results}

\item{...}{Other arguments passed to \code{\link{available.packages}}}
}
\description{
Each package is a node, and a dependency is an edge
}
\examples{



availPkgs <- cranJuly2014

\dontrun{
availPkgs <- pkgAvail(
  repos = c(CRAN="http://cran.revolutionanalytics.com"),
  type="source"
  )
}


# Create dependency graph using stored database of available packages
p <- makeDepGraph(
  c("ggplot2", "forecast"), 
  availPkgs = availPkgs
)

if(require(igraph)) plot(p)



\dontrun{
  # Create dependency graph using newly retrieved database from CRAN
  
  p <- makeDepGraph(
  c("ggplot2", "forecast"), 
  repos = c(CRAN="http://cran.revolutionanalytics.com"), 
  type="source"
)
if(require(igraph)) plot(p)
}
}
\seealso{
\code{\link{pkgDep}}, \code{\link{plot.pkgDepGraph}}

Other miniCRAN.functions: \code{\link{basePkgs}};
  \code{\link{makeRepo}}; \code{\link{pkgAvail}};
  \code{\link{pkgDep}}; \code{\link{plot.pkgDepGraph}}
}

