% Generated by roxygen2 (4.0.1): do not edit by hand
\name{pkgDep}
\alias{pkgDep}
\title{Retrieves package dependencies.}
\usage{
pkgDep(pkg, availPkgs, repos = getOption("repos"), type = "source",
  depends = TRUE, suggests = TRUE, enhances = FALSE,
  includeBasePkgs = FALSE, ...)
}
\arguments{
\item{pkg}{Character vector of packages.}

\item{availPkgs}{Vector of available packages.  Defaults to reading this list from CRAN, using \code{\link{available.packages}}}

\item{repos}{URL(s) of the 'contrib' sections of the repositories. Passed to \code{\link{available.packages}}}

\item{type}{Possible values are (currently) "source", "mac.binary" and "win.binary": the binary types can be listed and downloaded but not installed on other platforms.  Passed to \code{\link{download.packages}}.}

\item{depends}{If TRUE, retrieves Depends, Imports and LinkingTo dependencies (non-recursively)}

\item{suggests}{If TRUE, retrieves Suggests dependencies (non-recursively)}

\item{enhances}{If TRUE, retrieves Enhances dependencies (non-recursively)}

\item{includeBasePkgs}{If TRUE, include base R packages in results}

\item{...}{Other arguments passed to \code{\link{available.packages}}}
}
\description{
Performs recursive retrieve for \code{Depends}, \code{Imports} and \code{LinkLibrary}. Performs non-recursive retrieve for \code{Suggests}.
}
\details{
This
}
\examples{

\dontrun{
pkgDep(pkg=c("ggplot2", "plyr", "reshape2"), 
       repos=c(CRAN="http://cran.revolutionanalytics.com")
)
}

pdb <- cranJuly2014
\dontrun{
pdb <- pkgAvail(repos=c(CRAN="http://cran.revolutionanalytics.com"))
}

pkgDep(pkg=c("ggplot2", "plyr", "reshape2"), pdb)

}
\seealso{
\code{\link{makeDepGraph}}

Other miniCRAN.functions: \code{\link{basePkgs}};
  \code{\link{makeDepGraph}}; \code{\link{makeRepo}};
  \code{\link{pkgAvail}}; \code{\link{plot.pkgDepGraph}}
}

