# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

#' Update Nedap Dataset with Current Date
#'
#' @description
#' The `nedaps` function creates a copy of the Nedap dataset and adjusts the visit times 
#' to align with the current date while maintaining the original time patterns.
#'
#' @details
#' The function performs the following operations:
#' \itemize{
#'   \item Creates a copy of the Nedap dataset from the mintyr package
#'   \item Calculates the number of days between the last recorded visit and the previous day
#'   \item Shifts all visit times forward by the calculated number of days
#'   \item Preserves the original time patterns of the visits
#' }
#'
#' @return A `data.table` with updated visit times, shifted to the current date
#'
#' @note
#' - Requires the `data.table` and `mintyr` packages
#' - Uses the current system date as a reference for date shifting
#' - Maintains the original time of day for each visit
#'
#' @importFrom data.table copy IDateTime
#' @export
#' @examples
#' head(nedaps())
nedaps <- function() {
  visit_time <- time <- NULL
  data <- data.table::copy(mintyr::nedap)
  days_diff <- Sys.Date() - 1 - max(unique(as.Date(data$visit_time)))
  data[, `:=`(c("date", "time"), data.table::IDateTime(visit_time))
  ][, `:=`(date, as.Date(date) + days_diff)
  ][, visit_time := as.POSIXct(paste(date, time), format="%Y-%m-%d %H:%M:%S")
  ][, c("date", "time") := NULL][]
}

