% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isBalanced.R
\name{isBalanced}
\alias{isBalanced}
\title{Evaluate the mass or charge balance for a set of stoichiometric reactions}
\usage{
isBalanced(reactionList, referenceData, ids, mFormula = NULL,
  mWeight = NULL, mCharge = NULL)
}
\arguments{
\item{reactionList}{A set of stoichiometric reaction with the following format: 

\code{"H2O[c] + Urea-1-carboxylate[c] <=> 2 CO2[c] + 2 NH3[c]"} 

Where arrows and plus signs are surrounded by a "space character".
It is also expected that stoichiometry coefficients are surrounded by spaces, (nothe the "2" before the CO2[c] or the NH3[c]).
It also expects arrows to be in the form "\code{=>}" or "\code{<=>}". 
Meaning that arrows like "\code{==>}", "\code{<==>}", "\code{-->}" or "\code{->}" will not be parsed and will lead to errors.}

\item{referenceData}{A chemical table containing data to evaluate the balance}

\item{ids}{A mandatory id of metabolites id column in the referenceData}

\item{mFormula}{An optional id of molecular formula column in the referenceData}

\item{mWeight}{An optional id of molecular weight column in the referenceData}

\item{mCharge}{An optional id of net charge column in the referenceData}
}
\value{
This function returns a boolean value \code{'TRUE'} if reaction is balanced. Reactions without valid syntax are removed of the reactionList.
}
\description{
For a given set of stoichiometric reactions, this function evaluate the mass or charge balance based in a reference data. Return a boolean value \code{'TRUE'} if reaction is balanced. One of \code{'mFormula'}, \code{'mWeight'} or \code{'mCharge'} arguments must be given.
}
\examples{
# Using external chemical table
chemicalData <- read.csv2(system.file("extdata", "chemData.csv", package = "minval"))
head(chemicalData)

# Loading stoichiometric reactions
glycolysis <- read.csv2(system.file("extdata", "glycolysisKEGG.csv", package = "minval"))

# Evaluating mass balance
isBalanced(
 reactionList = glycolysis$REACTION, 
 referenceData = chemicalData, 
 ids = "NAME", 
 mFormula = "FORMULA"
 )

# Evaluating charge balance
isBalanced(
 reactionList = glycolysis$REACTION, 
 referenceData = chemicalData, 
 ids = "NAME",
 mCharge = "CHARGE"
 )
}
\author{
Daniel Camilo Osorio <dcosorioh@unal.edu.co>
}
\keyword{balance}
\keyword{charge}
\keyword{check}
\keyword{genome}
\keyword{mass}
\keyword{metabolic}
\keyword{reconstruction}
\keyword{scale}

