% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{launch_local}
\alias{launch_local}
\alias{launch_remote}
\title{Launch Daemon}
\usage{
launch_local(url, ..., tls = NULL, .compute = "default")

launch_remote(
  url,
  ...,
  tls = NULL,
  .compute = "default",
  rscript = "Rscript",
  command = NULL,
  args = c("", .)
)
}
\arguments{
\item{url}{the character host URL or vector of host URLs, including the port
    to connect to (and optionally for websockets, a path), e.g.
    tcp://192.168.0.2:5555' or 'ws://192.168.0.2:5555/path'

    \strong{or} integer index value, or vector of index values, of the
    dispatcher URLs, or 1L for the host URL (when not using dispatcher).}

\item{...}{(optional) additional arguments passed to \code{\link{daemon}}
(see 'additional arguments' section below).}

\item{tls}{[default NULL] required for secure TLS connections over tls+tcp or
wss. Zero-configuration TLS certificates generated by \code{\link{daemons}}
are automatically passed to the daemon, without requiring to be specified
here. Otherwise, supply \strong{either} the character path to a file
containing X.509 certificate(s) in PEM format, comprising the certificate
authority certificate chain, \strong{or} a length 2 character vector
comprising [i] the certificate authority certificate chain and [ii] the
empty character ''.}

\item{.compute}{[default 'default'] character compute profile (each compute
profile has its own set of daemons for connecting to different resources).}

\item{rscript}{[default 'Rscript'] name / path of the Rscript executable. The
default assumes 'Rscript' is on the executable search path on the remote
machine. Prepend the full path if necessary. If launching on Windows,
'Rscript' should be replaced with 'Rscript.exe'.}

\item{command}{(optional) the command used to effect the daemon launch on the
remote machine as a character string (e.g. \code{'ssh'}).}

\item{args}{(optional) arguments passed to 'command', as a character vector
that must include '\code{.}' (quoted or unquoted) as an element,
which will be substituted for the daemons launch command. As an example,
for SSH, valid arguments may comprise the port, destination IP, followed
by the daemons launch command. These could be specified in the manner of:
\code{c('-p 22 192.168.0.2', .)}.}
}
\value{
For \strong{launch_local}: Invisible NULL.

For \strong{launch_remote}: A character vector of daemon launch
    commands the same length as 'url'. For manual deployment, unescape the
    double quotes around the call to \code{"mirai::daemons()"}.
}
\description{
\code{launch_local} spawns a new background \code{Rscript} process calling
    \code{\link{daemon}} with the specified arguments. May be used to
    re-launch daemons that have timed out on the local machine.

\code{launch_remote} returns the shell command for launching daemons as a
    character vector. If 'command' is specified, this is executed with the
    arguments in 'args' to effect the daemon launch on the remote machine.
}
\details{
If daemons have been set, the generated command will automatically
    contain the argument 'rs' specifying the length 7 L'Ecuyer-CMRG random
    seed supplied to the daemon. The values will be different each time the
    function is called.
}
\section{Additional arguments}{


    Additional arguments may be specified as part of '\code{...}' to be
    passed on to \code{\link{daemon}}:

    \itemize{
    \item{\strong{asyncdial}} {[default FALSE] whether to perform dials
    asynchronously. The default FALSE will error if a connection is not
    immediately possible (e.g. \code{\link{daemons}} has yet to be called, or
    the specified port is not open etc.). Specifying TRUE continues retrying
    (indefinitely) if not immediately successful, which is more resilient but
    can mask potential connection issues.}
    \item{\strong{output}} {[default FALSE] Specify as TRUE to provide
    redirection of output (stdout and stderr) from the daemon to the host
    process. This option is only applicable for local daemons when not using
    dispatcher.}
    }
}

\examples{
if (interactive()) {
# Only run examples in interactive R sessions

daemons(url = "ws://[::1]:0", dispatcher = FALSE)
status()
launch_local(status()$daemons, maxtasks = 10L)
launch_remote(1L, maxtasks = 10L)
Sys.sleep(1)
status()
daemons(0)

daemons(n = 2L, url = "tls+tcp://[::1]:0")
status()
launch_local(1:2, idletime = 60000L, timerstart = 1L)
launch_remote(1:2, idletime = 60000L, timerstart = 1L)
Sys.sleep(1)
status()
daemons(0)

}

}
