% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daemons.R
\name{serialization}
\alias{serialization}
\title{Custom Serialization Functions}
\usage{
serialization(fns, class, vec = FALSE)
}
\arguments{
\item{fns}{\strong{either} a list comprising 2 functions: \cr serialization
function: must accept a reference object (or list of objects) inheriting
from \sQuote{class} and return a raw vector.\cr unserialization function:
must accept a raw vector and return a reference object (or list of
reference objects).\cr \strong{or else} NULL to reset.}

\item{class}{character string of the class of object custom serialization
functions are applied to, e.g. \sQuote{ArrowTabular} or
\sQuote{torch_tensor}.}

\item{vec}{[default FALSE] whether or not the serialization functions are
vectorized. If FALSE, they should accept and return reference objects
individually e.g. \code{arrow::write_to_raw} and
\code{arrow::read_ipc_stream}. If TRUE, they should accept and return a
list of reference objects, e.g. \code{torch::torch_serialize} and
\code{torch::torch_load}.}
}
\value{
Invisibly, a list comprising the currently-registered serialization
    configuration for the \sQuote{default} compute profile (an empty list if
    not registered).
}
\description{
[Deprecated in favour of the '.serial' argument to \code{\link{everywhere}}]
    Registers custom serialization and unserialization functions for
    reference objects. Settings apply only to the \sQuote{default} compute
    profile, and daemons must have been set beforehand.
}
\note{
This function is deprecated and will be removed in a later package
    version. Use \code{\link{serial_config}} to create a configuration to
    pass directly to the '.serial' argument of \code{\link{everywhere}}.
}
\keyword{internal}
