% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testinfo.R
\name{testinfo}
\alias{testinfo}
\title{Function to calculate test information}
\usage{
testinfo(x, Theta, degrees = NULL, group = NULL, individual = FALSE,
  which.items = 1:extract.mirt(x, "nitems"))
}
\arguments{
\item{x}{an estimated mirt object}

\item{Theta}{a matrix of latent trait values}

\item{degrees}{a vector of angles in degrees that are between 0 and 90.
Only applicable when the input object is multidimensional}

\item{group}{a number signifying which group the item should be extracted from (applies to
'MultipleGroupClass' objects only)}

\item{individual}{logical; return a data.frame of information traceline for each item?}

\item{which.items}{an integer vector indicating which items to include in the expected information function.
Default uses all possible items}
}
\description{
Given an estimated model compute the test information.
}
\examples{

\dontrun{
dat <- expand.table(deAyala)
(mirt(dat, 1, '2PL', pars = 'values'))
mod <- mirt(dat, 1, '2PL', constrain = list(c(1,5,9,13,17)))

Theta <- matrix(seq(-4,4,.01))
tinfo <- testinfo(mod, Theta)
plot(Theta, tinfo, type = 'l')

#compare information loss between two tests
tinfo_smaller <- testinfo(mod, Theta, which.items = 3:5)

#removed item informations
plot(Theta, iteminfo(extract.item(mod, 1), Theta), type = 'l')
plot(Theta, iteminfo(extract.item(mod, 2), Theta), type = 'l')

#most loss of info around -1 when removing items 1 and 2; expected given item info functions
plot(Theta, tinfo_smaller - tinfo, type = 'l')


}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{information}

