% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remap.distance.R
\name{remap.distance}
\alias{remap.distance}
\title{Remap item categories to have integer distances of 1}
\usage{
remap.distance(data, message = TRUE)
}
\arguments{
\item{data}{the response data to remap as a data.frame or matrix}

\item{message}{logical; print message information pertaining to which items were remapped?}
}
\description{
The mirt package's estimation setup requires that all item responses have spaces
equal to 1 (e.g., a Likert scale scored from 1 through 5). In the event that categories
are missing the categories must be re-coded. This function is automatically called by
the package estimation functions (e.g., \code{\link{mirt}}), however for convince this
function has been extracted for users to better understand the remapping consequences.
}
\examples{

# category 2 for item 1 missing
dat <- Science
dat[,1] <- ifelse(Science[,1] == 2, 1, Science[,1])
apply(dat, 2, table)

# mirt() automatically remaps categories
mod <- mirt(dat, 1)
coef(mod, simplify=TRUE)

# this is the transformed data used by mirt()
remap_dat <- remap.distance(dat)
apply(remap_dat, 2, table)


}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
