% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_saem.R
\name{pred_saem}
\alias{pred_saem}
\title{pred_saem}
\usage{
pred_saem(X.test, beta.saem, mu.saem, sig2.saem, seed = 200,
  method = "map")
}
\arguments{
\item{X.test}{Design matrix in test set.}

\item{beta.saem}{Estimated \eqn{\beta}{\beta} by SAEM.}

\item{mu.saem}{Estimated \eqn{\mu}{\mu} by SAEM.}

\item{sig2.saem}{Estimated \eqn{\Sigma}{\Sigma} by SAEM.}

\item{seed}{An integer as a seed set for the radom generator. The default value is 200.}

\item{method}{The name of method to deal with missing values in test set. It can be 'map'(maximum a posteriori) or 'impute' (imputation by conditional expectation). Default is 'map'.}
}
\value{
\item{pr.saem}{The prediction result for logistic regression: the probability of response y=1.}
}
\description{
Prediction on test with missing values for the logistic regression model.
}
\examples{
# Generate dataset
N <- 100  # number of subjects
p <- 3     # number of explanatory variables
mu.star <- rep(0,p)  # mean of the explanatory variables
Sigma.star <- diag(rep(1,p)) # covariance
beta.star <- c(1, 1,  0) # coefficients
beta0.star <- 0 # intercept
beta.true = c(beta0.star,beta.star)
X.complete <- matrix(rnorm(N*p), nrow=N)\%*\%chol(Sigma.star) +
              matrix(rep(mu.star,N), nrow=N, byrow = TRUE)
p1 <- 1/(1+exp(-X.complete\%*\%beta.star-beta0.star))
y <- as.numeric(runif(N)<p1)
# Generate missingness
p.miss <- 0.10
patterns <- runif(N*p)<p.miss #missing completely at random
X.obs <- X.complete
X.obs[patterns] <- NA

# SAEM
list.saem = miss.saem(X.obs,y)

# Generate test set with missingness
Nt = 50
X.test <- matrix(rnorm(Nt*p), nrow=Nt)\%*\%chol(Sigma.star)+
              matrix(rep(mu.star,Nt), nrow=Nt, byrow = TRUE)
p1 <- 1/(1+exp(-X.test\%*\%beta.star-beta0.star))
y.test <- as.numeric(runif(Nt)<p1)

# Prediction on test set
pr.saem <- pred_saem(X.test, list.saem$beta, list.saem$mu, list.saem$sig2)
pred.saem <- (pr.saem>0.5)*1
table(y.test, pred.saem)
}
