% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqCI.R
\name{qqci}
\alias{qqci}
\title{qqci function}
\usage{
qqci(
  x,
  rfun = rnorm,
  ns = 100,
  zero = FALSE,
  standardise = FALSE,
  qts = c(0.025, 0.975),
  lwd = 2
)
}
\arguments{
\item{x}{a vector of values to compare}

\item{rfun}{a function accepting a single argument to generate samples from the comparison distribution, the default is rnorm}

\item{ns}{the number of simulations to generate: the more simulations, the more accurate the confidence bands. Default is 100}

\item{zero}{logical, whether to zero the plot across the x-axis. Default is FALSE}

\item{standardise}{logical, whether to standardise so that the variance around each quantile is made constant (this can help in situations where the confidence bands appear very tight in places)}

\item{qts}{vector of probabilities giving which sample-based empirical quantiles to add to the plot. Default is c(0.025,0.975)}

\item{lwd}{positive numeric, the width of line to plot}
}
\value{
Produces a QQ-plot with simulation-based confidence bands
}
\description{
A function to compare quantiles of a given vector against quantiles of a specified distribution. The function outputs
simulation-based confidence intervals too. The option of zero-ing the plot (rather than visualising a diagonal line (which
can be difficult to interpret) and also standardising (so that varying uncertainty around each quantile appears equal to the eye)
are also given.
}
\examples{
qqci(rnorm(1000))
qqci(rnorm(1000),zero=TRUE)
qqci(rnorm(1000),zero=TRUE,standardise=TRUE)
}
