% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotGrid.R
\name{ggplotGrid}
\alias{ggplotGrid}
\alias{ggplotGridA4}
\alias{ggplotlist}
\title{Arrange a List of ggplots}
\usage{
ggplotGrid(l, path, ncol = 1, nrow = 1, width = 8, height = 11,
  res = 300, pdf.cairo = TRUE, onefile = TRUE, ...)

ggplotGridA4(l, path, ncol = 2, nrow = 1, wide = TRUE)

ggplotlist(x, ncol = 1, path, width = 11, height = 8)
}
\arguments{
\item{l}{List with ggplot objects.}

\item{path}{Plot to file of type pdf or png. Determine type by
path ending (.pdf or .png).\cr
Optional in \code{ggplotlist}: A character string that gives the path to export
the plot to a file, ending with 'pdf' or 'png' (case insensitive). If
missing, then the grid is returned to the current graphic device.}

\item{ncol}{Number of columns.}

\item{nrow}{Number of rows per page, only for pdfs.}

\item{width}{For pdfs/pngs the width in inches, else ignored.}

\item{height}{For pdfs/pngs the height in inches, else ignored.}

\item{res}{Resolution in dpi for pngs.}

\item{pdf.cairo}{Use \link{cairo_pdf} (or cairo_ps, svg) instead of \link{pdf}}

\item{onefile}{Create one file, see \link{cairo_pdf}.}

\item{...}{Forwarded to cairo_pdf}

\item{wide}{Wide format pdf pages (11x8 inches).}

\item{x}{A list containing at least one ggplot object of class \code{gg}.}
}
\description{
Arrange a list of ggplots with \link[gridExtra]{grid.arrange} and
output on local graphic device or as pdf/png when a path is supplied.
\code{ggplotGridA4} writes the plots to a DIN A4 (8 x 11 inches) pdf file
directly.
}
\examples{
#

\dontrun{
library(ggplot2)
d <- data.frame(a=1:5,b=1:5)
x <- list(
  ggplot(d, aes(x=a,y=b,col=b)) + geom_line(),
  ggplot(d, aes(x=a,y=b,shape=factor(b))) + geom_point())
ggplotlist(x, 2)}

#
}
\author{
Sven E. Templer
}
