% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library.R
\name{md.mvnorm}
\alias{md.mvnorm}
\title{md.mvnorm}
\usage{
md.mvnorm(names, means = rep(0, length(names)), cov = diag(ncol(names)))
}
\arguments{
\item{names}{vector of covariate names}

\item{means}{vector of means, default is \code{rep(0, length(names))}}

\item{cov}{covariance matrix, default is \code{diag(ncol(names))}}
}
\description{
Creates information of a vector of multi-normal covariates with the specified array of means and covariance matrix.
This function call must be added to the \code{\link{md.simparams}} object.
}
\examples{

\dontrun{
library(missDeaths)

sim = md.simparams() +
   md.mvnorm(c("X1", "X2"), c(100, 0), matrix(c(225, 3, 2, 1), 2, 2))
}
}

