% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_convergence.R
\name{calculate_convergence}
\alias{calculate_convergence}
\title{Calculates convergence based on NMSE}
\usage{
calculate_convergence(err, weights)
}
\arguments{
\item{err}{dataframe containing OOB or apparent errors for each iteration.}

\item{weights}{vector of weights in the same format as for the \code{missForest} function.}
}
\value{
A list with elements
    \item{\code{converged}}{boolean indicating if the algorithm has converged (TRUE) or not (FALSE)}
    \item{\code{measure_old}}{the total error of the previous iteration}
    \item{\code{measure_new}}{the total error of the last iteration}
}
\description{
Calculates convergence based on NMSE. Details on the convergence criterion calculation are
provided in the package vignettes.
}
