% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missForest.R
\name{missForest}
\alias{missForest}
\title{Imputes a dataframe and returns imputation models to be used on new observations}
\usage{
missForest(
  xmis,
  maxiter = 10,
  fixed_maxiter = FALSE,
  var_weights = NULL,
  decreasing = FALSE,
  initialization = "mean/mode",
  x_init = NULL,
  class.weights = NULL,
  return_integer_as_integer = FALSE,
  save_models = TRUE,
  predictor_matrix = NULL,
  proportion_usable_cases = c(1, 0),
  verbose = TRUE,
  convergence_error = "OOB",
  ...
)
}
\arguments{
\item{xmis}{dataframe containing missing values of class dataframe ("tibble" class tbl_df is also supported). Matrix format is not supported. See details for column format.}

\item{maxiter}{maximum number of iterations. By default the algorithm will stop when converge is reached or
after running for maxiter, whichever occurs first.}

\item{fixed_maxiter}{if set to TRUE, the algorithm will run for the exact number of iterations specified in maxiter,
regardless of the convergence criteria. Default is FALSE.}

\item{var_weights}{named vector of weights for each variable in the convergence criteria.
The names should correspond to variable names.
By default the weights are set to the proportion of missing values on each variable.}

\item{decreasing}{(boolean) if TRUE the order in which the variables are imputed is by decreasing amount of missing values.
(the variable with highest amount of missing values will be imputed first). If FALSE the variable with lowest amount of missing values will be imputed first.}

\item{initialization}{initialization method before running RF models; supported: mean/mode, median/mode and custom. Default is mean/mode.}

\item{x_init}{if \code{initialization = custom}; a complete dataframe to be used as initialization (see vignette for example).}

\item{class.weights}{a named list containing \code{class.weights} parameter to be passed to ranger for categorical variables.
The names of the list needs to respect the names of the categorical variables in the dataframe.
(See \code{ranger} function documentation in \code{ranger} package for details).}

\item{return_integer_as_integer}{Internally, integer columns are treated as double (double precision floating point numbers).
If TRUE, the imputations will be rounded to closest integer and returned as integer (This might be desirable for count variables).
If FALSE, integer columns will be returned as double (This might be desirable, for example, for patient age imputation).
Default is FALSE. The same behaviour will be applied to new observations when using missForestPredict.}

\item{save_models}{if TRUE, imputation models are saved and a new observation (or a test set) can be imputed using the models learned;
saving models on a dataset with a high number of variables will occupy RAM memory on the machine. Default is TRUE.}

\item{predictor_matrix}{predictor matrix indicating which variables to use in the imputation of each variable.
See documentation for function \code{create_predictor_matrix} for details on the matrix format.}

\item{proportion_usable_cases}{a vector with two components: the first one is a minimum threshold for \code{p_obs}
and the second one is a maximum threshold for \code{p_miss}. Variables for which \code{p_obs} is greater than or equal to 1 (by default)
will be filtered from the predictor matrix. Variables for which \code{p_miss} is lower than or equal to 0 (by default)
will be filtered from the predictor matrix. For more details on \code{p_obs} and \code{p_miss} see the documentation for
the \code{prop_usable_cases} function. If parameter \code{predictor_matrix} is specified, the \code{proportion_usable_cases}
will be applied to this provided matrix.}

\item{verbose}{(boolean) if TRUE then missForest returns OOB error estimates (MSE and NMSE) and runtime.}

\item{convergence_error}{Which error should be used for the convergence criterion. Supported values: OOB and apparent.
If a different value is provided, it defaults to OOB. See vignette for full details on convergence.}

\item{...}{other arguments passed to ranger function (some arguments that are specific to each variable type are not supported).
See vignette for \code{num.trees} example.}
}
\value{
Object of class \code{missForest} with elements
    \item{\code{ximp}}{dataframe with imputed values}
    \item{\code{init}}{x_init if custom initalization is used; otherwise list of mean/mode or median/mode for each variable}
    \item{\code{initialization}}{value of initialization parameter}
    \item{\code{impute_sequence}}{vector variable names in the order in which imputation has been run}
    \item{\code{maxiter}}{maxiter parameter as passed to the function}
    \item{\code{models}}{list of random forest models for each iteration}
    \item{\code{return_integer_as_integer}}{Parameter return_integer_as_integer as passed to the function}
    \item{\code{integer_columns}}{list of columns of integer type in the data}
    \item{\code{OOB_err}}{dataframe with out-of-bag errors for each iteration and each variable}
}
\description{
Imputes a dataframe and (if save_models = TRUE) returns imputation models to be used on new observations.
}
\details{
An adaptation of the original missForest algorithm (Stekhoven et al. 2012) is used.
Variables are initialized with a mean/mode, median/mode or custom imputation.
Then, they are imputed iteratively "on the fly" for a maximum number of iterations or until the convergence criteria are met.
The imputation sequence is either increasing or decreasing.
At each iteration, a random forest model is build for each variable using as outcome on the observed (non-missing) values
of the variable and as predictors the values of the other variables from previous iteration
for the first variable in the sequence or current iteration for next variables in the sequence
(on-the-fly). The ranger package (Wright et al. 2017) is used for building the random forest models.

The convergence criterion is based on the out-of-boostrap (OOB) error or the apparent error and uses NMSE (normalized mean squared error)
for both continuous and categorical variables.

Imputation models for all variables and all iterations are saved (if \code{save_models} is TRUE)  and can be later
applied to new observations.

Both dataframe and tibble (tbl_df class) are supported as input. The imputed dataframe will be retured with the same class.
Numeric and integer columns are supported and treated internally as continuous variables.
Factor and character columns are supported and treated internally as categorical variables.
Other types (like boolean or dates) are not supported.
NA values are considered missing values.
}
\examples{
data(iris)
iris_mis <- produce_NA(iris, proportion = 0.1)
imputation_object <- missForest(iris_mis, num.threads = 2)
iris_imp <- imputation_object$ximp

}
\references{
\itemize{
    \item Stekhoven, D. J., & Bühlmann, P. (2012). MissForest-non-parametric missing value imputation for mixed-type data. Bioinformatics, 28(1), 112-118. \doi{10.1093/bioinformatics/btr597}
    \item Wright, M. N. & Ziegler, A. (2017). ranger: A fast implementation of random forests for high dimensional data in C++ and R. J Stat Softw 77:1-17. \doi{10.18637/jss.v077.i01}.
  }
}
