#' Adjusting Stochastic Block Models under various missing data conditions
#'
#' The missSBM package provides the following top-level functions functions:
#' \itemize{
#'   \item{\code{\link{observeNetwork}}}{a function to draw a partially observe network from an existing, fully observed network according to a variety of sampling designs}
#'   \item{\code{\link{estimateMissSBM}}}{a function to perform inference of SBM from a partially observed under various sampling designs.}
#' }
#'
#' These function leads to the manipulation of a variety of R objects instantiated from some R6 classes, with their respective fields and methods.
#' They are all generated by the top-level functions itemized above, so that the user should generally not use their constructor or internal methods
#' directly. The user should only have a basic understanding of the fields of each object to manipulate the output in R. The main objects are the following:
#' \itemize{
#' \item{[`missSBM_fit`]}{an object that put together an SBM fit and and network sampling fit - the main point of the missSBM package !}
#' \item{[`missSBM_collection`]}{an object to store a collection of missSBM_fit, ordered by number of block}
#' \item{[`SimpleSBM_fit_MNAR`]}{an object to define and store an SBM fit with MNAR values}
#' \item{[`SimpleSBM_fit_noCov`]}{an object to define and store an SBM fit without covariate, MAR values}
#' \item{[`SimpleSBM_fit_withCov`]}{an object to define and store an SBM fit with covariates, MAR values}
#' \item{[`networkSampling`]}{an object to define and store a network sampling fit}
#' }
#'
#' missSBM extends some functionality of the package sbm, by inheriting from classes and methods associated to simple stochastic block models.
#'
#'
#' @author Pierre Barbillon \email{pierre.barbillon@@agroparistech.fr}
#' @author Julien Chiquet \email{julien.chiquet@@inrae.fr}
#' @author Timothée Tabouy \email{timothee.tabouy@@gmail.com}
#' @references
#' Pierre Barbillon, Julien Chiquet & Timothée Tabouy (2022) "missSBM: An R Package for Handling Missing Values in the Stochastic Block Model", Journal of Statistical Software, \doi{10.18637/jss.v101.i12}
#'
#' Timothée Tabouy, Pierre Barbillon & Julien Chiquet (2019) “Variational Inference for Stochastic Block Models from Sampled Data”, Journal of the American Statistical Association, \doi{10.1080/01621459.2018.1562934}
#'
#' @import R6 methods igraph nloptr Matrix
#' @importFrom Rcpp sourceCpp
#' @useDynLib missSBM, .registration = TRUE
#' @docType package
#' @name missSBM
NULL
