% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi.coef.R
\name{phi.coef}
\alias{phi.coef}
\title{Phi Coefficient}
\usage{
phi.coef(x, adjust = FALSE, tri = c("both", "lower", "upper"), digits = 2,
         as.na = NULL, check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a matrix or data frame.}

\item{adjust}{logical: if \code{TRUE}, phi coefficient is adjusted by relating
the coefficient to the possible maximum.}

\item{tri}{a character string or character vector indicating which triangular of the matrix
to show on the console, i.e., \code{both} for upper and lower triangular,
\code{lower} (default) for the lower triangular, and \code{upper} for the upper
triangular.}

\item{digits}{an integer value indicating the number of decimal places digits to be used for
displaying phi coefficients.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown on the console.}
}
\value{
Returns an object of class \code{phi.coef}, which is a list with following entries: function call (\code{call}),
matrix or data frame specified in \code{x} (\code{data}), specification of function arguments (\code{args}), and
list with results (\code{result}).
}
\description{
This function computes the (adjusted) Phi coefficient between two or more than two dichotomous variables.
}
\details{
The maximum Phi coefficient is determined by the distribution of the two variables, i.e., the Phi
coefficient cannot achieve the value of 1 in many cases. According to Cureton (1959), the' phi
coefficient can be adjusted by relating the coefficient to the possible maximum, \eqn{\phi / \phi_max}.
}
\examples{
dat <- data.frame(x1 = c(0, 1, 0, 1, 0, 1, 0, 1, 1, 0),
                  x2 = c(0, 1, 0, 0, 1, 1, 1, 1, 1, 1),
                  x3 = c(0, 1, 0, 1, 1, 1, 1, 1, 0, 0))

# Phi coefficient between x1 and x2
phi.coef(dat[, c("x1", "x2")])

# Adjusted phi coefficient between x1 and x2
phi.coef(dat[, c("x1", "x2")], adjust = TRUE)

# Phi coefficient matrix between x1, x2, and x3
phi.coef(dat)

# Adjusted phi coefficient matrix between x1, x2, and x3
phi.coef(dat, adjust = TRUE)
}
\references{
Cureton, E. E. (1959). Note on Phi/Phi max. \emph{Psychometrika, 24}, 89-91.

Davenport, E. C., & El-Sanhurry, N. A. (1991). Phi/Phimax: Review and synthesis. \emph{Educational and
Psychological Measurement, 51}, 821-828. https://doi.org/10.1177/001316449105100403

Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
