% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilevel.fit.R
\name{multilevel.fit}
\alias{multilevel.fit}
\title{Simultaneous and Level-Specific Multilevel Model Fit Information}
\usage{
multilevel.fit(x, print = c("all", "summary", "fit"), digits = 3, p.digits = 3,
               write = NULL, check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a fitted model of class \code{"lavaan"} from the \pkg{lavaan}
package.}

\item{print}{a character string or character vector indicating which results
to show on the console, i.e. \code{"all"} for all results,
\code{"summary"} for a summary of the specification of the
estimation method and missing data handling in lavaan and
\code{"fit"} for model fit.}

\item{digits}{an integer value indicating the number of decimal places
to be used for displaying results. Note that loglikelihood,
information criteria and chi-square test statistic is
printed with \code{digits} minus 1 decimal places.}

\item{p.digits}{an integer value indicating the number of decimal places to be
used for displaying the \emph{p}-value.}

\item{write}{a character string for writing the results into a Excel file
naming a file with or without file extension '.xlsx', e.g.,
\code{"Results.xlsx"} or \code{"Results"}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:
\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{x}}{a fitted model of class \code{"lavaan"}}
\item{\code{args}}{specification of function arguments}
\item{\code{model}}{specified models, i.e., \code{mod.l1} for the model at the
                    Within level, \code{mod.l1.syntax} for the lavaan syntax
                    for the model at the Between level, \code{mod.l2} for the
                    model at the Within level, \code{mod.l2.syntax} for the
                    lavaan syntax for the model at the Between level,
                    \code{mod.l12} for the model at the Within and Between
                    level, \code{mod.l12.syntax} for the lavaan syntax for
                    the model at the Within and Between level, \code{l1.mod.base}
                    for the baseline model at the Within level saturated at
                    the Between level, \code{l1.mod.hypo} for the hypothesized
                    model at the Within level saturated at the Between level,
                    \code{l2.mod.base} for the baseline model at the Between
                    level saturated at the Within level, \code{l2.mod.hypo}
                    for the hypothesized model at the Between level saturated
                    at the Within level}
\item{\code{result}}{list with result tables, i.e., \code{summary} for the
                     summary of the specification of the estimation method
                     and missing data handling in lavaan and \code{fit} for
                     the model fit information.}
}
\description{
This function provides simultaneous and level-specific model fit information
using the partially saturated model method for multilevel models estimated
with the \pkg{lavaan} package. Note that level-specific fit indices cannot
be computed when the fitted model contains cross-level constraints, e.g.,
equal factor loadings across levels in line with the metric cross-level
measurement invariance assumption.
}
\note{
The function uses the functions \code{cfa}, \code{fitmeasures}, \code{lavInspect},
\code{lavTech}, and \code{parTable} provided in the R package \pkg{lavaan} by
Yves Rosseel (2012).
}
\examples{
\dontrun{
# Load data set "Demo.twolevel" in the lavaan package
data("Demo.twolevel", package = "lavaan")

# Model specification
model <- 'level: 1
              fw =~ y1 + y2 + y3
              fw ~ x1 + x2 + x3
           level: 2
              fb =~ y1 + y2 + y3
              fb ~ w1 + w2'

#---------------------------
# Model estimation with estimator = "ML"
fit1 <- lavaan::sem(model = model, data = Demo.twolevel, cluster = "cluster",
                    estimator = "ML")

# Simultaneous and kevel-specific multilevel model fit information
ls.fit1 <- multilevel.fit(fit1)

# Write results into an Excel file
write.result(ls.fit1, "LS-Fit1.xlsx")

#---------------------------
# Model estimation with estimator = "MLR"
fit2 <- lavaan::sem(model = model, data = Demo.twolevel, cluster = "cluster",
                    estimator = "MLR")

# Simultaneous and kevel-specific multilevel model fit information
# Write results into an Excel file
multilevel.fit(fit2, write = "LS-Fit2.xlsx")
}
}
\references{
Rosseel, Y. (2012). lavaan: An R Package for Structural Equation Modeling.
\emph{Journal of Statistical Software, 48}, 1-36. https://doi.org/10.18637/jss.v048.i02
}
\seealso{
\code{\link{multilevel.cfa}}, \code{\link{multilevel.invar}},
\code{\link{multilevel.omega}}, \code{\link{multilevel.cor}},
\code{\link{multilevel.descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
