% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blimp.R
\name{blimp}
\alias{blimp}
\title{Create, Run, and Print Blimp Models}
\usage{
blimp(x, file = "Blimp_Input.imp", data = NULL, comment = FALSE, replace.inp = TRUE,
      blimp.run = TRUE, posterior = FALSE, folder = "Posterior_",
      format = c("csv", "csv2", "excel", "rds", "workspace"), clear = TRUE,
      replace.out = c("always", "never", "modified"), Blimp = detect.blimp(),
      result = c("all", "default", "algo.options", "data.info", "model.info",
                 "warn.mess", "out.model", "gen.param"),
      exclude = NULL, color = c("none", "blue", "violet"),
      style = c("bold", "regular"), not.result = TRUE, write = NULL,
      append = TRUE, check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a character string containing the Blimp input text.}

\item{file}{a character string indicating the name of the Blimp input
file with or without the file extension \code{.imp}, e.g.,
\code{"Blimp_Input.imp"} or \code{"Blimp_Input.imp"}.}

\item{data}{a matrix or data frame from which the variables names for
the section \code{VARIABLES} are extracted.}

\item{comment}{logical: if \code{FALSE} (default), comments (i.e., text
after the \code{#} symbol) are removed from the input text
specified in the argument \code{x}.}

\item{replace.inp}{logical: if \code{TRUE} (default), an existing input
file will be replaced.}

\item{blimp.run}{logical: if \code{TRUE}, the input file specified in the
argument \code{file} containing the input text specified
in the argument \code{x} is run using the \code{blimp.run()}
function.}

\item{posterior}{logical: if \code{TRUE}, the posterior distribution including
burn-in and post-burn-in phase for all parameters are saved
in long format in a file called \code{posterior.*} in the
folder specified in the argument \code{folder} and \code{.imp}
file name in the format specified in the argument \code{format}.}

\item{folder}{a character string indicating the prefix of the folder for
saving the posterior distributions. The default setting is
\code{folder = "Posterior_"}.}

\item{format}{a character vector indicating the file format(s) for saving the
posterior distributions, i.e., \code{"csv"} (default) for
\code{write.csv()}, \code{"csv2"} for \code{write.csv2()},
\code{"excel"} for \code{write.xlsx()}, \code{"rds"} for
\code{saveRDS()}, and \code{"workspace"} for \code{write()}.}

\item{clear}{logical: if \code{TRUE} (default), the console is cleared
after estimating each model.}

\item{replace.out}{a character string for specifying three settings:
\code{"always"} (default), which runs all models, regardless
of whether an output file for the model exists, \code{"never"},
which does not run any model that has an existing output file,
and \code{"modified"}, which only runs a model if the
modified date for the input file is more recent than the
output file modified date.}

\item{Blimp}{a character string for specifying the name or path of the
Blimp executable to be used for running models. This covers
situations where Blimp is not in the system's path, or where
one wants to test different versions of the Blimp program.
Note that there is no need to specify this argument for most
users since it has intelligent defaults.}

\item{result}{a character vector specifying Blimp result sections included
in the output (see 'Details' in the \code{\link{blimp.print}}
function).}

\item{exclude}{a character vector specifying Blimp input command or result
sections excluded from the output (see 'Details' in the
\code{\link{blimp.print}} function).}

\item{color}{a character vector with two elements indicating the colors
used for the main headers (e.g., \code{"ALGORITHMIC OPTIONS SPECIFIED:"}),
and for the headers \code{Outcome Variable:} and
\code{Missing predictor:}, \code{Latent Variable:},
and \code{Covariance Matrix:}.}

\item{style}{a character vector with two elements indicating the style
used for headers (e.g., \code{"ALGORITHMIC OPTIONS SPECIFIED:"}),
and for the main headers (e.g., \code{"ALGORITHMIC OPTIONS SPECIFIED:"}),
and for the headers \code{Outcome Variable:} and
\code{Missing predictor:}, \code{Complete variable:}, \code{Latent Variable:},
and \code{Covariance Matrix:}.}

\item{not.result}{logical: if \code{TRUE} (default), character vector indicating
the result sections not requested are shown on the console.}

\item{write}{a character string naming a file for writing the output into
a text file with file extension \code{".txt"} (e.g.,
\code{"Output.txt"}).}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is
checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the
console by using the function \code{blimp.print()}.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:

\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{x}}{a character vector containing the Blimp input text}
\item{\code{args}}{specification of function arguments}
\item{\code{write}}{write command sections}
\item{\code{result}}{list with result sections (\code{result})}
}
\description{
This wrapper function creates a Blimp input file, runs the input file by using
the \code{blimp.run()} function, and prints the Blimp output file by using the
\code{blimp.print()} function.
}
\details{
\describe{
\item{\strong{\code{VARIABLES} Section}}{The \code{VARIABLES} section used to
assign names to the variables in the data set can be specified by using
the \code{data} argument:
   \itemize{
      \item{\code{Write Blimp Data File}}: In the first step, the Blimp data
      file is written by using the \code{write.mplus()} function, e.g.
      \code{write.mplus(data1, file = "data1.dat")}.
      \item{\code{Specify Blimp Input}}: In the second step, the Blimp input
      is specified as a character string. The \code{VARIABLES} option is left
      out from the Blimp input text, e.g.,
      \code{input <- 'DATA: data1.dat;\nMODEL: y ~ x1@b1 x2@b2 d2;'}.
      \item{\code{Run Blimp Input}}: In the third step, the Blimp input is run
      by using the \code{blimp()} function. The argument \code{data} needs to be
      specified given that the \code{VARIABLES} section was left out from the
      Blimp input text in the previous step, e.g., \code{blimp(input, file = "Ex4.3.imp", data = data1)}.
   }
 Note that unlike Mplus, Blimp allows to specify a CSV data file with variable
 names in the first row. Hence, it is recommended to export the data from
 R using the \code{write.csv()} function to specify the data file in the \code{DATA}
 section of the Blimp input file without specifying the \code{VARIABLES} section.
}
}
}
\examples{
\dontrun{
#----------------------------------------------------------------------------
# Example 1: Write data, specify input without VARIABLES section, and run input

# Write Data File
# Note that row.names = FALSE needs to be specified
write.csv(data1, file = "data1.csv", row.names = FALSE)

# Specify Blimp input
input1 <- '
DATA: data1.csv;
ORDINAL: d;
MISSING: 999;
FIXED: d;
CENTER: x1 x2;
MODEL: y ~ x1 x2 d;
SEED: 90291;
BURN: 1000;
ITERATIONS: 10000;
'

# Run Blimp input
blimp(input1, file = "Ex4.3.imp")

#----------------------------------------------------------------------------
# Example 2: Write data, specify input with VARIABLES section, and run input

# Write Data File
write.mplus(data1, file = "data1.dat", input = FALSE)

# Specify Blimp input
input2 <- '
DATA: data1.dat;
VARIABLES: id v1 v2 v3 y x1 d x2 v4;
ORDINAL: d;
MISSING: 999;
FIXED: d;
CENTER: x1 x2;
MODEL: y ~ x1 x2 d;
SEED: 90291;
BURN: 1000;
ITERATIONS: 10000;
'

# Run Blimp input
blimp(input2, file = "Ex4.3.imp")

#----------------------------------------------------------------------------
# Example 3: Alternative specification using the data argument

# Write Data File
write.mplus(data1, file = "data1.dat", input = FALSE)

# Specify Blimp input
input3 <- '
DATA: data1.dat;
ORDINAL: d;
MISSING: 999;
FIXED: d;
CENTER: x1 x2;
MODEL: y ~ x1 x2 d;
SEED: 90291;
BURN: 1000;
ITERATIONS: 10000;
'

# Run Blimp input
blimp(input3, file = "Ex4.3.imp", data = data1)
}
}
\references{
Keller, B. T., & Enders, C. K. (2023). \emph{Blimp user’s guide} (Version 3).
Retrieved from www.appliedmissingdata.com/blimp
}
\seealso{
\code{\link{blimp.update}}, \code{\link{blimp.run}},
\code{\link{blimp.print}}, \code{\link{blimp.plot}}, \code{\link{blimp.bayes}}
}
\author{
Takuya Yanagida
}
