## print normal mixture

printnormal <- function(x, digits) {
	ncomp <- length(x$pi)
	name <- paste("comp", 1:ncomp, sep = "")
	res1 <- matrix(0, nrow = 3, ncol = ncomp)
	rownames(res1) <- c("pi", "mu", "sd")
	colnames(res1) <- name
	res1[1, ] <- x$pi
	res1[2, ] <- x$mu
	res1[3, ] <- x$sd
	res2 <- c(x$iter, x$aic, x$bic)
	names(res2) <- c("EM iteration", "AIC", "BIC")
	cat(paste("Normal mixture model with", ncomp, "components\n"))
	print(round(res1, digits))
	cat("\n")
	cat(paste(c("EM iterations:", x$iter, "AIC:", round(x$aic, digits), 
	"BIC:", round(x$bic, digits), "log-likelihood:", round(x$loglik, digits))))
}