% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnormpar.R
\name{to_mulog_sdlog_lnorm}
\alias{to_mulog_sdlog_lnorm}
\title{Parameter Conversion for Lognormal Distribution}
\usage{
to_mulog_sdlog_lnorm(mu, sd)
}
\arguments{
\item{mu}{a vector of means of lognormal distributions}

\item{sd}{a vector of standard deviations of lognormal distributions}
}
\value{
a list of two items
\item{mulog}{a vector of lognormal means of lognormal distributions}
\item{sdlog}{a vector of lognormal standard deviations of lognormal distributions}
}
\description{
The function \code{to_mulog_sdlog_lnorm} converts the mean and standard deviation to
the logarithm mean and logarithm standard deviation
}
\details{
The purpose of this function is to convert the parameterization of lognormal distribution in the
form of mean and standard deviation to the form of logarithm mean and logarithm standard deviation.
It can be used for specifying the initial values for the EM algorithm when the first-hand initial values
are in the form of mean and standard deviation from K-means clustering algorithm.
}
\examples{
to_mulog_sdlog_lnorm(2, 1)
to_mulog_sdlog_lnorm(c(2, 4), c(1, 1))

}
\seealso{
\code{\link{to_mu_sd_lnorm}}
}
