\name{cband}
\alias{cband}
\title{
Calculate confidence and prediction bands for mixtures of one-variable
regressions.
}
\description{
Produces confidence and prediction bands, two-sided or upper or
lower, for the lines fitted in a model consisting of a mixture of
one-variable regressions.
}
\usage{
cband(object, alpha=0.05, MC=FALSE, xlen=100, plot=FALSE,...)
}
\arguments{
\item{object}{
Object describing the fitted mixture of regressions, as returned
by \code{\link{mixreg}()}.
}
\item{alpha}{
One minus the confidence level for the confidence and prediction
bands; e.g. alpha = 0.05 for 95\% confidence.
}
\item{MC}{
  Logical scalar; should the covariance matrix of the parameter estimates
  be calculated by a Monte Carlo procedure?  If the covariance matrix
  is extracted from \code{object}, the \code{"MC"} attribute of this
  matrix is checked.  If argument \code{MC} disagrees with this attribute
  then the covariance matrix is re-calculated using the appropriate
  procedure.
}
\item{xlen}{
The number of points to be plotted in the band envelopes.  The
\eqn{x}-values of the points will be equispaced from the minimum
to the maximum of the predictor variable.
}
\item{plot}{
Logical scalar; should a plot of the fitted model
and confidence and prediction bands be produced immediately?
}
\item{...}{
  Extra arguments to be passed to \code{\link{covMixMC}()} if the covariance
  matrix needs to be (re-) calculated and \code{MC} is \code{TRUE}.
}
}
\value{
An object of class \code{"cband"}, consisting of a list with entries:
\item{theta}{
The parameter list from object (as returned by mixreg).
}
\item{intercept}{
The logical value from object indicating whether intercepts were fitted.
}
\item{x}{
The predictor for the model (extracted from the \code{data} entry
of \code{object}).
}
\item{y}{
The response for the model (extracted from the \code{data} entry
of \code{object}).
}
\item{xf}{
The equispaced sequence of values, extending from \code{min(x)}
to \code{max(x)}, at which the values of the band envelopes were
calculated.
}
\item{bnds}{
A list with one entry for each component of the mixture.  Each entry
is a matrix with 8 columns (lower and upper confidence and prediction
bounds for one-sided intervals and lower and upper confidence and prediction 
bounds for two-sided interval).
}
\item{alpha}{
  Numeric scalar; the \code{alpha} argument.
}
\item{varnms}{
  Character vector of length two providing the names of the predictor (first entry)
  and of the response (second entry).
}
If \code{plot} is \code{TRUE} the value is returned invisibly.
}
\section{Side Effects}{
If \code{plot} is \code{TRUE} a plot of the fit and the confidence
and prediction bands is produced in whatever device is currently
open or on screen if no device is open.
}
\section{Warning}{
    If \code{MC} is \code{FALSE} then an error may be thrown if
    the observed Fisher information (the inverse of which is use
    as the estimated covariance matrix) is singular.  Note that
    if \code{MC} is FALSE then any call to \code{covMix()} is
    made with \code{useMC="no"}.
}
\details{
The prediction bands are conditional in that the associated probability
is conditional upon the associated observation being generated by
the relevant component of the mixture.

The covariance matrix need to construct the confidence and prediction
bands is extracted from \code{object}, given that \code{object} has
an entry named \code{"covMat"} (i.e. if the call to \code{mixreg} that produced
\code{object} was made with \code{covMat=TRUE}).  If \code{object}
has no such entry then \code{covMix()} is called to produce the covariance
matrix.  (Such a call may take a bit of time.)
}
\author{Rolf Turner
  \email{r.turner@auckland.ac.nz}
}
\references{
T. Rolf Turner (2000). Estimating the rate of spread of a
viral infection of potato plants via mixtures of regressions.
\emph{Applied Statistics} \bold{49} Part 3, pp. 371 -- 384.
}
\seealso{
\code{\link{ncMcTest}()}, \code{\link{covMix}()},
\code{\link{mixreg}()}, \code{\link{plot.cband}()},
\code{\link{residuals.mixreg}()}, \code{\link{plot.mixresid}()},
\code{\link{qqMix}()},
}
\examples{
# Aphids.
    thStrt <- list(list(beta=c(3.0,0.1),sigsq=16,lambda=0.5),
                   list(beta=c(0.0,0.0),sigsq=16,lambda=0.5))
    fit    <- mixreg(plntsInf~aphRel,ncomp=2,thetaStart=thStrt,
                     covMat=TRUE,data=aphids)
    cbds   <- cband(fit,plot=TRUE)
    plot(cbds) # Same plot as was produced by call to cband().
# Kilns.
   thStrt <- list(
                   list(beta=c(26.07,48808),sigsq=1.1573,lambda=0.33333333),
                   list(beta=c(23.48,32387),sigsq=1.8730,lambda=0.33333333),
                   list(beta=c(-0.0597,20760),sigsq=0.2478,lambda=0.33333333)
                 )
    fit    <- mixreg(y ~ x,ncomp=3,data=kilnAoneOut,thetaStart=thStrt)
    \dontrun{ # Takes too long.
        res    <- residuals(fit,std=TRUE)
        qqMix(res) # No way are these residuals Gaussian!
        cbdsG  <- cband(fit)
        cbdsMC <- cband(fit,MC=TRUE)
        plot(cbdsG)
        plot(cbdsMC)
    # Same-same, despite the lack of Gaussianity!
    }
}
\keyword{models}
\keyword{regression}
