% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_node.R
\name{rev.ctx_node}
\alias{rev.ctx_node}
\title{Reverse Sequence}
\usage{
\method{rev}{ctx_node}(x)
}
\arguments{
\item{x}{a \code{ctx_node} object as returned by \code{\link[=find_sequence]{find_sequence()}}}
}
\value{
a \code{ctx_node} using the opposite ordering convention as the parameter
of the function
}
\description{
This function reverses the order in which the sequence represented by the
\code{ctx_node} parameter will be reported in other functions, mainly
\code{\link[=as_sequence]{as_sequence()}}.
}
\examples{
dts <- c("A", "B", "C", "A", "A", "B", "B", "C", "C", "A")
dts_tree <- ctx_tree(dts, max_depth = 3)
res <- find_sequence(dts_tree, c("A", "B"))
print(res)
r_res <- rev(res)
print(r_res)
as_sequence(r_res)
}
\seealso{
\code{\link[=is_reversed]{is_reversed()}}
}
