% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setFishing.R
\name{validGearParams}
\alias{validGearParams}
\title{Check validity of gear parameters and set defaults}
\usage{
validGearParams(gear_params, species_params)
}
\arguments{
\item{gear_params}{Gear parameter data frame}

\item{species_params}{Species parameter data frame}
}
\value{
A valid gear parameter data frame
}
\description{
The function returns a valid gear parameter data frame that can be used
by \code{setFishing()} or it gives an error message.
}
\details{
If gear_params is empty, then this function tries to find the necessary
information in the species_params data frame. This restricts each species
to be fished by only one gear. Defaults are used for information that can
not be found in the species_params dataframe, as follows:
\itemize{
\item If there is no \code{gear} column, each species gets its own gear, named after
the species.
\item If there is no \code{sel_func} column or it is NA then \code{knife_edge} is used.
\item If there is no \code{catchability} column or it is NA then this is set to 1.
\item If the selectivity function is \code{knife_edge} and no \code{knife_edge_size} is
provided, it is set to \code{w_mat}.
}
}
\concept{helper}
