% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{SheperdRDD}
\alias{SheperdRDD}
\title{Sheperd function to calculate density-dependent reproduction rate}
\usage{
SheperdRDD(rdi, species_params, ...)
}
\arguments{
\item{rdi}{Vector of density-independent reproduction rates
\eqn{R_{di}}{R_di} for all species.}

\item{species_params}{A species parameter dataframe. Must contain columns
\code{sheperd_b} and \code{sheperd_c} with the parameters b and c.}

\item{...}{Unused}
}
\value{
Vector of density-dependent reproduction rates.
}
\description{
Takes the density-independent rates \eqn{R_{di}}{R_di} of egg production and returns
reduced, density-dependent rates \eqn{R_{dd}}{R_dd} given as
\deqn{R_{dd} = \frac{R_{di}}{1+(b\ R_{di})^c}}{R_dd = R_di / (1 + (b R_di)^c)}
}
\seealso{
Other functions calculating density-dependent reproduction rate: 
\code{\link{BevertonHoltRDD}()},
\code{\link{RickerRDD}()},
\code{\link{constantRDD}()},
\code{\link{noRDD}()}
}
\concept{functions calculating density-dependent reproduction rate}
