% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mizer-package.R
\docType{package}
\name{mizer-package}
\alias{mizer}
\alias{mizer-package}
\title{mizer: Multi-species size-based modelling in R}
\description{
The mizer package implements multi-species size-based modelling in R. It has
been designed for modelling marine ecosystems.
}
\details{
Using \pkg{mizer} is relatively simple.  There are three main stages:
\enumerate{
\item \emph{Setting the model parameters}. This is done by creating an object of
class \linkS4class{MizerParams}. This includes model parameters such as the
life history parameters of each species, and the range of the size spectrum.
There are several setup functions that help to create a MizerParams objects
for particular types of models:
\itemize{
\item \code{\link[=newCommunityParams]{newCommunityParams()}}
\item \code{\link[=newTraitParams]{newTraitParams()}}
\item \code{\link[=newMultispeciesParams]{newMultispeciesParams()}}
}
\item \emph{Running a simulation}. This is done by calling the
\code{\link[=project]{project()}} function with the model parameters. This produces an
object of \linkS4class{MizerSim} that contains the results of the simulation.
\item \emph{Exploring results}. After a simulation has been run, the results can be
explored using a range of \link{plotting_functions}, \link{summary_functions} and
\link{indicator_functions}.
}

See the \href{https://sizespectrum.org/mizer/}{mizer website} for full details of
the principles behind mizer and how the package can be used to perform
size-based modelling.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://sizespectrum.org/mizer/}
  \item \url{https://github.com/sizespectrum/mizer}
  \item Report bugs at \url{https://github.com/sizespectrum/mizer/issues}
}

}
\author{
\strong{Maintainer}: Gustav Delius \email{gustav.delius@york.ac.uk} (\href{https://orcid.org/0000-0003-4092-8228}{ORCID}) [copyright holder]

Authors:
\itemize{
  \item Finlay Scott \email{drfinlayscott@gmail.com} [copyright holder]
  \item Julia Blanchard \email{julia.blanchard@utas.edu.au} (\href{https://orcid.org/0000-0003-0532-4824}{ORCID}) [copyright holder]
  \item Ken Andersen \email{kha@aqua.dtu.dk} (\href{https://orcid.org/0000-0002-8478-3430}{ORCID}) [copyright holder]
}

Other contributors:
\itemize{
  \item Richard Southwell \email{richard.southwell@york.ac.uk} [contributor, copyright holder]
}

}
