% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{mldr_evaluate}
\alias{mldr_evaluate}
\title{Evaluate predictions made by a multilabel classifier}
\usage{
mldr_evaluate(mldr, predictions, threshold = 0.5)
}
\arguments{
\item{mldr}{Object of \code{"mldr"} class containing the instances to evaluate}

\item{predictions}{Matrix with the labels predicted for each instance in the \code{mldr} parameter. Each element
should be a value into [0,1] range}

\item{threshold}{Threshold to use to generate bipartition of labels. By default the value 0.5 is used}
}
\value{
A list with multilabel predictive performance measures. The items in the list will be \itemize{
 \item \code{accuracy}
 \item \code{example_auc}
 \item \code{average_precision}
 \item \code{coverage}
 \item \code{fmeasure}
 \item \code{hamming_loss}
 \item \code{macro_auc}
 \item \code{macro_fmeasure}
 \item \code{macro_precision}
 \item \code{macro_recall}
 \item \code{micro_auc}
 \item \code{micro_fmeasure}
 \item \code{micro_precision}
 \item \code{micro_recall}
 \item \code{one_error}
 \item \code{precision}
 \item \code{ranking_loss}
 \item \code{recall}
 \item \code{subset_accuracy}
 \item \code{roc}
 }
 The \code{roc} element corresponds to a \code{roc} object associated to the \code{MicroAUC} value. This object can be given as input to \code{plot} for plotting the ROC curve
 The \code{example_auc}, \code{macro_auc}, \code{micro_auc} and \code{roc} members will be \code{NULL} if the \code{pROC} package is not installed.
}
\description{
Taking as input an \code{mldr} object and a matrix with the predictions
given by a classifier, this function evaluates the classifier performance through
several multilabel metrics.
}
\examples{
\dontrun{
library(mldr)

# Get the true labels in emotions
predictions <- as.matrix(emotions$dataset[, emotions$labels$index])
# and introduce some noise (alternatively get the predictions from some classifier)
noised_labels <- cbind(sample(1:593, 200, replace = TRUE), sample(1:6, 200, replace = TRUE))
predictions[noised_labels] <- sample(0:1, 100, replace = TRUE)
# then evaluate predictive performance
res <- mldr_evaluate(emotions, predictions)
str(res)
plot(res$roc, main = "ROC curve for emotions")
}
}
\seealso{
\code{\link{mldr}}, \link{Basic metrics}, \link{Averaged metrics}, \link{Ranking-based metrics}, \code{\link{roc.mldr}}
}
