% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlmm_allmodels_withsommer.R
\name{mlmm_allmodels}
\alias{mlmm_allmodels}
\title{Multi-Locus Mixed-Model}
\usage{
mlmm_allmodels(Y, XX, KK, nbchunks = 2, maxsteps = 20, cofs = NULL,
  female = NULL, male = NULL, threshold=NULL)
}
\arguments{
\item{Y}{A numeric named vector where the names are individuals' names and the values their phenotype. The names of Y will be matched to the row names of X.}

\item{XX}{A list of length one, two or three matrices depending on the model. Matrices are n by m matrix, where n=number of individuals, m=number of SNPs, with rownames(X)=individual names, and colnames(X)=SNP names.

- additive: a single matrix

- additive+dominance: two matrices

- female+male: two matrices with the female one first

- female+male+interaction: three matrices with the female first, the male then the interaction}

\item{KK}{a list of one, two or three matrices depending on the models

- additive: a n by n matrix, where n=number of individuals, with rownames()=colnames()=individual names

- additive+dominance: two n by n matrices, where n=number of individuals, with rownames()=colnames()=individual names

- female+male: a n.female by n.female matrix, with rownames()=colnames()=female names and a n.male by n.male matrix, with rownames()=colnames()=male names

- female+male+interaction: the same two matrices as the model female+male and a n by n matrix, where n=number of individuals, with rownames()=colnames()=individual names}

\item{nbchunks}{An integer defining the number of chunks of matrices to run the analysis, allows to decrease the memory usage. minimum=2, increase it if you do not have enough memory}

\item{maxsteps}{An integer >= 3. Maximum number of steps desired in the forward approach. The forward approach breaks automatically once the pseudo-heritability is close to 0, however to avoid doing too many steps in case the pseudo-heritability does not reach a value close to 0, this parameter is also used.}

\item{cofs}{A n by q matrix, where n=number of individuals, q=number of fixed effect, with rownames()=individual names and with column names, forbidden head of column names for this matrix "eff1_" and usage of special characters as "*","/","&"}

\item{female}{A factor of levels female names and length n, only for the last two models}

\item{male}{A factor of levels male names and length n, only for the last two models}
\item{threshold}{a value to declare the significant p value. The default value is Bonferroni 0.05}
}
\value{
a list with one element per step of the forward approach. Each element of this list is a named vector of p-values, the names are the names of the markers, with "selec_" as prefix for the markers used as fixed effects.
}
\description{
Carry GWAS correcting for population structure while including cofactors through a forward regression approach.

possible models: additive, additive+dominance, female+male, female+male+interaction

For additive model, look at the example below or at this \href{../doc/gwas-manual.html}{vignette}. For other models, read \href{https://link.springer.com/article/10.1007/s00122-017-3003-4}{Bonnafous et al. (2017)}.
}
\details{
Each of the data arguments must be sorted in the same way, according to the individual name.
}
\examples{
### Data for additive and additive+dominance models

data("mlmm.gwas.AD")

### Additive model ###

XX = list(Xa)
KK = list(K.add)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateAD, XX, KK)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateAD, sel_XX, KK, ncol(Xa))

# Marker selection
res.threshold <- threshold_allmodels(threshold=NULL, res_mlmm)

# Effects estimations with the selected model
sel_XXclass <- fromeBICtoEstimation(sel_XX, res.eBIC, res.threshold)
eff.estimations <- Estimation_allmodels(floweringDateAD, sel_XXclass, KK)
genotypes.boxplot(Xa, floweringDateAD, effects = eff.estimations)

\dontrun{
### Additive + dominance model

XX = list(Xa, Xd)
KK = list(K.add, K.dom)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateAD, XX, KK)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateAD, sel_XX, KK, ncol(Xa))
#the selected model is the null model

# Marker selection 
res.threshold <- threshold_allmodels(threshold=NULL, res_mlmm)

### Data for female+male and female+male+interaction

data("mlmm.gwas.FMI")

### Female+Male model

XX = list(Xf, Xm)
KK = list(K.female, K.male)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateFMI, XX, KK, female = female, male = male)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateFMI, sel_XX, KK, ncol(Xf), female = female, male = male)
#the selected model is the null model

# Marker selection 
res.threshold <- threshold_allmodels(threshold=NULL, res_mlmm)


### Female+Male+Interaction model

XX = list(Xf, Xm, Xfm)
KK = list(K.female, K.male, K.hybrid)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateFMI, XX, KK, female = female, male = male)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateFMI, sel_XX, KK, ncol(Xf), female = female, male = male)
#the selected model is the null model

# Marker selection 
res.threshold <- threshold_allmodels(threshold=NULL, res_mlmm)

}
}
\seealso{
\code{\link{manhattan.plot}}
}
