% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmm_loglik.R
\name{hmm_loglik}
\alias{hmm_loglik}
\title{Hidden Markov Model (HMM) Sequence Log-Likelihood}
\usage{
hmm_loglik(input, input_model, verbose = getOption("mlpack.verbose", FALSE))
}
\arguments{
\item{input}{File containing observations (numeric matrix).}

\item{input_model}{File containing HMM (HMMModel).}

\item{verbose}{Display informational messages and the full list of
parameters and timers at the end of execution.  Default value
"getOption("mlpack.verbose", FALSE)" (logical).}
}
\value{
A list with several components:
\item{log_likelihood}{Log-likelihood of the sequence.  Default value "0"
  (numeric).}
}
\description{
A utility for computing the log-likelihood of a sequence for Hidden Markov
Models (HMMs).  Given a pre-trained HMM and an observation sequence, this
computes and returns the log-likelihood of that sequence being observed from
that HMM.
}
\details{
This utility takes an already-trained HMM, specified with the "input_model"
parameter, and evaluates the log-likelihood of a sequence of observations,
given with the "input" parameter.  The computed log-likelihood is given as
output.
}
\examples{
# For example, to compute the log-likelihood of the sequence "seq" with the
# pre-trained HMM "hmm", the following command may be used: 

\dontrun{
hmm_loglik(input=seq, input_model=hmm)
}
}
\author{
mlpack developers
}
