% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess_one_hot_encoding.R
\name{preprocess_one_hot_encoding}
\alias{preprocess_one_hot_encoding}
\title{One Hot Encoding}
\usage{
preprocess_one_hot_encoding(
  input,
  dimensions = NA,
  verbose = getOption("mlpack.verbose", FALSE)
)
}
\arguments{
\item{input}{Matrix containing data (numeric matrix/data.frame with
info).}

\item{dimensions}{Index of dimensions that need to be one-hot encoded
(if unspecified, all categorical dimensions are one-hot encoded) (integer
vector).}

\item{verbose}{Display informational messages and the full list of
parameters and timers at the end of execution.  Default value
"getOption("mlpack.verbose", FALSE)" (logical).}
}
\value{
A list with several components:
\item{output}{Matrix to save one-hot encoded features data to (numeric
  matrix).}
}
\description{
A utility to do one-hot encoding on features of dataset.
}
\details{
This utility takes a dataset and a vector of indices and does one-hot
encoding of the respective features at those indices. Indices represent the
IDs of the dimensions to be one-hot encoded.

If no dimensions are specified with "dimensions", then all categorical-type
dimensions will be one-hot encoded. Otherwise, only the dimensions given in
"dimensions" will be one-hot encoded.

The output matrix with encoded features may be saved with the "output"
parameters.
}
\examples{
# So, a simple example where we want to encode 1st and 3rd feature from
# dataset "X" into "X_output" would be

\dontrun{
output <- preprocess_one_hot_encoding(input=X, dimensions=1, dimensions=3)
X_ouput <- output$output
}
}
\author{
mlpack developers
}
