% Generated by roxygen2 (4.0.2): do not edit by hand
\name{makeImputeWrapper}
\alias{makeImputeWrapper}
\title{Fuse learner with an imputation method.}
\usage{
makeImputeWrapper(learner, classes = list(), cols = list(),
  dummy.cols = character(0L), dummy.type = "factor",
  impute.new.levels = TRUE, recode.factor.levels = TRUE)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{classes}{[\code{named list}]\cr
Named list containing imputation techniques for classes of columns.
E.g. \code{list(numeric = imputeMedian())}.}

\item{cols}{[\code{named list}]\cr
Named list containing names of imputation methods to impute missing values
in the data column referenced by the list element's name. Overrules imputation set via
\code{classes}.}

\item{dummy.cols}{[\code{character}]\cr
Column names to create dummy columns (containing binary missing indicator) for.
Default is \code{character(0)}.}

\item{dummy.type}{[\code{character(1)}]\cr
How dummy columns are encoded. Either as 0/1 with type \dQuote{numeric}
or as \dQuote{factor}.
Default is \dQuote{factor}.}

\item{impute.new.levels}{[\code{logical(1)}]\cr
If new, unencountered factor level occur during reimputation,
should these be handled as NAs and then be imputed the same way?
Default is \code{TRUE}.}

\item{recode.factor.levels}{[\code{logical(1)}]\cr
Recode factor levels after reimputation, so they match the respective element of
\code{lvls} (in the description object) and therefore match the levels of the
feature factor in the training data after imputation?.
Default is \code{TRUE}.}
}
\value{
[\code{\link{Learner}}].
}
\description{
Fuses a base learner with an imputation method. Creates a learner object, which can be
used like any other learner object.
Internally uses \code{\link{impute}} before training the learner and \code{\link{reimpute}}
before predicting.
}
\seealso{
Other impute: \code{\link{imputations}},
  \code{\link{imputeConstant}}, \code{\link{imputeHist}},
  \code{\link{imputeLearner}}, \code{\link{imputeMax}},
  \code{\link{imputeMean}}, \code{\link{imputeMedian}},
  \code{\link{imputeMin}}, \code{\link{imputeMode}},
  \code{\link{imputeNormal}}, \code{\link{imputeUniform}};
  \code{\link{impute}}; \code{\link{makeImputeMethod}};
  \code{\link{reimpute}}

Other wrapper: \code{\link{CostSensClassifModel}},
  \code{\link{CostSensClassifWrapper}},
  \code{\link{makeCostSensClassifWrapper}};
  \code{\link{CostSensRegrModel}},
  \code{\link{CostSensRegrWrapper}},
  \code{\link{makeCostSensRegrWrapper}};
  \code{\link{makeBaggingWrapper}};
  \code{\link{makeDownsampleWrapper}};
  \code{\link{makeFeatSelWrapper}};
  \code{\link{makeFilterWrapper}};
  \code{\link{makeMulticlassWrapper}};
  \code{\link{makeOverBaggingWrapper}};
  \code{\link{makeOversampleWrapper}},
  \code{\link{makeUndersampleWrapper}};
  \code{\link{makePreprocWrapper}};
  \code{\link{makeSMOTEWrapper}};
  \code{\link{makeTuneWrapper}};
  \code{\link{makeWeightedClassesWrapper}}
}

