% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prediction.R
\docType{data}
\name{Prediction}
\alias{Prediction}
\title{Abstract Prediction Object}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
This is the abstract base class for task objects like \link{PredictionClassif} or \link{PredictionRegr}.

Prediction objects store the following information:
\enumerate{
\item The row ids of the test set
\item The corresponding true (observed) response.
\item The corresponding predicted response.
\item Additional predictions based on the class and \code{predict_type}.
E.g., the class probabilities for classification or the estimated standard error for regression.
}
}
\section{Construction}{

This object is constructed via a derived classes, e.g. \link{PredictionClassif} or \link{PredictionRegr}.
}

\section{Fields}{

\itemize{
\item \code{row_ids} :: (\code{integer()} | \code{character()})\cr
Vector of row ids for which predictions are stored.
\item \code{truth} :: \code{any}\cr
True (observed) outcome.
\item \code{task_type} :: \code{character(1)}\cr
Stores the type of the \link{Task}.
\item \code{predict_types} :: \code{character()}\cr
Vector of predict types this object stores.
\item \code{missing} :: \code{logical()}\cr
Returns \code{row_ids} for which the predictions are missing or incomplete.
}
}

\section{Methods}{

\itemize{
\item \code{score(measures = NULL, task = NULL, learner = NULL)}\cr
(\code{list()} of \link{Measure}, \link{Task}, \link{Learner}) -> \link{Prediction}\cr
Calculates the performance for all provided measures
If no measure is provided, defaults to the measure defined in \link[=mlr_reflections]{mlr_reflections$default_measures}
(\link{mlr_measures_classif.ce} for classification and \link{mlr_measures_regr.mse} for regression).
\link{Task} and \link{Learner} may be \code{NULL} for many measures, but some measures need to extract information
from these objects.
}
}

\section{S3 Methods}{

\itemize{
\item \code{as.data.table(rr)}\cr
\link{Prediction} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Converts the data to a \code{\link[data.table:data.table]{data.table::data.table()}}.
\item \code{c(..., keep_duplicates = TRUE)}\cr
(\link{Prediction}, \link{Prediction}, ...) -> \link{Prediction}\cr
Combines multiple \code{Prediction}s to a single \code{Prediction}.
If \code{keep_duplicates} is \code{FALSE} and there are duplicated row ids,
the data of the former passed objects get overwritten by the data of the later passed objects.
}
}

\seealso{
Other Prediction: \code{\link{PredictionClassif}},
  \code{\link{PredictionRegr}}
}
\concept{Prediction}
\keyword{datasets}
