% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResampleResult.R
\docType{data}
\name{ResampleResult}
\alias{ResampleResult}
\title{Container for Results of \code{resample()}}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
This is the result container object returned by \code{\link[=resample]{resample()}}.

Note that all stored objects are accessed by reference.
Do not modify any object without cloning it first.
}
\section{Construction}{
\preformatted{rr = ResampleResult$new(data)
}
\itemize{
\item \code{data} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Table with data for one resampling iteration per row:
\link{Task}, \link{Learner}, \link{Resampling}, iteration (\code{integer(1)}), and \link{Prediction}.
}
}

\section{Fields}{

\itemize{
\item \code{data} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Internal data storage.
We discourage users to directly work with this field.
\item \code{task} :: \link{Task}\cr
The task \code{\link[=resample]{resample()}} operated on.
\item \code{learners} :: list of \link{Learner}\cr
List of trained learners, sorted by resampling iteration.
\item \code{resampling} :: \link{Resampling}\cr
Instantiated \link{Resampling} object which stores the splits into training and test.
\item \code{predictions} :: list of \link{Prediction}\cr
List of prediction objects, sorted by resampling iteration.
\item \code{prediction} :: \link{Prediction}\cr
Combined \link{Prediction} of all individual resampling iterations.
Note that the performance of measures is not calculated on this object,
but instead on each iterations separately and then combined with an aggregate function.
\item \code{warnings} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a table with all warning messages.
Column names are \code{"iteration"} and \code{"msg"}.
Note that there can be multiple rows per resampling iteration if multiple warnings have been recorded.
\item \code{errors} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a table with all error messages.
Column names are \code{"iteration"} and \code{"msg"}.
Note that there can be multiple rows per resampling iteration if multiple errors have been recorded.
\item \code{hash} :: \code{character(1)}\cr
Hash (unique identifier) for this object.
}
}

\section{Methods}{

\itemize{
\item \code{combine(rr)}\cr
\link{ResampleResult} -> \link{BenchmarkResult}\cr
Takes a second \link{ResampleResult} and combines both \link{ResampleResult}s to a \link{BenchmarkResult}.
\item \code{performance(measures = NULL, ids = TRUE)}\cr
(\code{list()} of \link{Measure}, \code{logical(1)}) -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a table with one row for each resampling iteration, including all involved objects.
Additionally calculates the provided performance measures and binds the performance as extra column.
If \code{ids} is \code{TRUE}, character column of id names are added to the table for convenient filtering.
\item \code{aggregate(measures = NULL)}\cr
\code{list()} of \link{Measure} -> named \code{numeric()}\cr
Calculates and aggregates performance values for all provided measures.
See \link{Measure} for the aggregation function.
}
}

\section{S3 Methods}{

\itemize{
\item \code{as.data.table(rr)}\cr
\link{ResampleResult} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a copy of the internal data.
}
}

\examples{
rr = resample("iris", "classif.featureless", "cv3")
print(rr)
rr$aggregate("classif.acc")
rr$prediction
rr$prediction$confusion
rr$warnings
rr$errors
}
\keyword{datasets}
