% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingInsample.R
\name{mlr_resamplings_insample}
\alias{mlr_resamplings_insample}
\alias{ResamplingInsample}
\title{Insample Resampling}
\description{
Uses all observations as training and as test set.
}
\section{Dictionary}{

This \link{Resampling} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_resamplings} or with the associated sugar function \code{\link[=rsmp]{rsmp()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_resamplings$get("insample")
rsmp("insample")
}\if{html}{\out{</div>}}
}

\examples{
# Create a task with 10 observations
task = tsk("penguins")
task$filter(1:10)

# Instantiate Resampling
insample = rsmp("insample")
insample$instantiate(task)

# Train set equal to test set:
setequal(insample$train_set(1), insample$test_set(1))

# Internal storage:
insample$instance # just row ids
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/performance.html#sec-resampling}
\item Package \CRANpkg{mlr3spatiotempcv} for spatio-temporal resamplings.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Resampling]{Resamplings}: \link{mlr_resamplings}
\item \code{as.data.table(mlr_resamplings)} for a table of available \link[=Resampling]{Resamplings} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3spatiotempcv} for additional \link{Resampling}s for spatio-temporal
tasks.
}

Other Resampling: 
\code{\link{Resampling}},
\code{\link{mlr_resamplings_bootstrap}},
\code{\link{mlr_resamplings_custom_cv}},
\code{\link{mlr_resamplings_custom}},
\code{\link{mlr_resamplings_cv}},
\code{\link{mlr_resamplings_holdout}},
\code{\link{mlr_resamplings_loo}},
\code{\link{mlr_resamplings_repeated_cv}},
\code{\link{mlr_resamplings_subsampling}},
\code{\link{mlr_resamplings}}
}
\concept{Resampling}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingInsample}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{iters}}{(\code{integer(1)})\cr
Returns the number of resampling iterations, depending on the values stored in the \code{param_set}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResamplingInsample-new}{\code{ResamplingInsample$new()}}
\item \href{#method-ResamplingInsample-clone}{\code{ResamplingInsample$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format"><a href='../../mlr3/html/Resampling.html#method-Resampling-format'><code>mlr3::Resampling$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help"><a href='../../mlr3/html/Resampling.html#method-Resampling-help'><code>mlr3::Resampling$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="instantiate"><a href='../../mlr3/html/Resampling.html#method-Resampling-instantiate'><code>mlr3::Resampling$instantiate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print"><a href='../../mlr3/html/Resampling.html#method-Resampling-print'><code>mlr3::Resampling$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-test_set'><code>mlr3::Resampling$test_set()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-train_set'><code>mlr3::Resampling$train_set()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingInsample-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingInsample-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingInsample$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingInsample-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingInsample-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingInsample$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
