% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BenchmarkAggr.R
\name{as.BenchmarkAggr}
\alias{as.BenchmarkAggr}
\title{Coercions to BenchmarkAggr}
\usage{
as.BenchmarkAggr(obj, independent = TRUE, strip_prefix = TRUE, ...)
}
\arguments{
\item{obj}{(\link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}|\code{matrix(1)}) \cr Passed to \link{BenchmarkAggr}\verb{$new()}.}

\item{independent, strip_prefix}{See \link{BenchmarkAggr}\verb{$initialize()}.}

\item{...}{\code{ANY} \cr Passed to \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}\verb{$aggregate()}.}
}
\description{
Coercion methods to \link{BenchmarkAggr}. For \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult} this is a simple
wrapper around the \link{BenchmarkAggr} constructor called with \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}\verb{$aggregate()}.
}
\examples{
df = data.frame(task_id = rep(c("A", "B"), each = 5),
                learner_id = paste0("L", 1:5),
                RMSE = runif(10), MAE = runif(10))

as.BenchmarkAggr(df)


if (requireNamespaces(c("mlr3", "rpart"))) {
  library(mlr3)
  task = tsks(c("boston_housing", "mtcars"))
  learns = lrns(c("regr.featureless", "regr.rpart"))
  bm = benchmark(benchmark_grid(task, learns, rsmp("cv", folds = 2)))

  # default measure
  as.BenchmarkAggr(bm)

  # change measure
  as.BenchmarkAggr(bm, measure = msr("regr.rmse"))
}

}
