% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureFairness.R
\name{MeasureFairness}
\alias{MeasureFairness}
\title{Base Measure for Fairness}
\description{
This measure extends \code{\link[mlr3:Measure]{mlr3::Measure()}} with statistical group fairness:
A common approach to quantifying a model's fairness is to compute the difference between a
protected and an unprotected group according w.r.t. some performance metric, e.g.
\verb{classification error} (\link{mlr_measures_classif.ce}) or \verb{false positive rate}
(\link{mlr_measures_classif.fpr}).
The operation for comparison (e.g., difference or quotient) can be specified using the \code{operation}
parameter, e.g. \code{\link[=groupdiff_absdiff]{groupdiff_absdiff()}} or \code{\link[=groupdiff_tau]{groupdiff_tau()}}.

Composite measures encompasing multiple fairness metrics can be built using
\link{MeasureFairnessComposite}.

Some popular predefined measures can be found in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_measures}.
}
\examples{
# Create MeasureFairness to measure the Predictive Parity.
t = tsk("adult_train")
learner = lrn("classif.rpart", cp = .01)
learner$train(t)
measure = msr("fairness", base_measure = msr("classif.ppv"))
predictions = learner$predict(t)
predictions$score(measure, task = t)
}
\seealso{
\link{MeasureFairnessComposite}
}
\section{Super class}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{MeasureFairness}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{base_measure}}{(\code{Measure()})\cr
The base measure to be used by the fairness measures,
e.g. \link{mlr_measures_classif.fpr} for the false positive rate.}

\item{\code{operation}}{(\verb{function()})\cr
The operation used to compute the difference. A function with args 'x' and 'y' that returns
a single value. Defaults to \code{abs(x - y)}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeasureFairness-new}{\code{MeasureFairness$new()}}
\item \href{#method-MeasureFairness-clone}{\code{MeasureFairness$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate"><a href='../../mlr3/html/Measure.html#method-Measure-aggregate'><code>mlr3::Measure$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format"><a href='../../mlr3/html/Measure.html#method-Measure-format'><code>mlr3::Measure$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help"><a href='../../mlr3/html/Measure.html#method-Measure-help'><code>mlr3::Measure$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="print"><a href='../../mlr3/html/Measure.html#method-Measure-print'><code>mlr3::Measure$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score"><a href='../../mlr3/html/Measure.html#method-Measure-score'><code>mlr3::Measure$score()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureFairness-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureFairness-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureFairness$new(
  id = NULL,
  base_measure,
  operation = groupdiff_absdiff,
  minimize = TRUE,
  range = c(-Inf, Inf)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character})\cr
The measure's id. Set to 'fairness.<base_measure_id>' if ommited.}

\item{\code{base_measure}}{(\code{Measure()})\cr
The base metric evaluated within each subgroup.}

\item{\code{operation}}{(\code{function})\cr
The operation used to compute the difference. A function that returns
a single value given input: computed metric for each subgroup.
Defaults to \link{groupdiff_absdiff}.}

\item{\code{minimize}}{(\code{logical()})\cr
Should the measure be minimized? Defaults to \code{TRUE}.}

\item{\code{range}}{(\code{numeric(2)})\cr
Range of the resulting measure. Defaults to \code{c(-Inf, Inf)}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureFairness-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureFairness-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureFairness$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
