% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loop_function.R
\name{loop_function}
\alias{loop_function}
\title{Loop Functions for Bayesian Optimization}
\description{
Loop functions determine the behavior of the Bayesian Optimization algorithm on a global level.
For an overview of readily available loop functions, see \code{as.data.table(mlr_loop_functions)}.

In general, a loop function is simply a decorated member of the S3 class \code{loop_function}.
Attributes must include: \code{id} (id of the loop function), \code{label} (brief description), \code{instance} ("single-crit" and
or "multi_crit"), and \code{man} (link to the manual page).

As an example, see, e.g., \link{bayesopt_ego}.
}
\seealso{
Other Loop Function: 
\code{\link{mlr_loop_functions}},
\code{\link{mlr_loop_functions_ego}},
\code{\link{mlr_loop_functions_emo}},
\code{\link{mlr_loop_functions_mpcl}},
\code{\link{mlr_loop_functions_parego}},
\code{\link{mlr_loop_functions_smsego}}
}
\concept{Loop Function}
