% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_fbeta.R
\name{fbeta}
\alias{fbeta}
\title{F-beta Score}
\usage{
fbeta(truth, response, positive, beta = 1, na_value = NaN, ...)
}
\arguments{
\item{truth}{:: \code{factor()}\cr
True (observed) labels.
Must have the exactly same two levels and the same length as \code{response}.}

\item{response}{:: \code{factor()}\cr
Predicted response labels.
Must have the exactly same two levels and the same length as \code{truth}.}

\item{positive}{:: \code{character(1)}\cr
Name of the positive class.}

\item{beta}{:: \code{numeric(1)}\cr
Parameter to give either precision or recall more weight.
Default is 1, resulting in balanced weights.}

\item{na_value}{:: \code{numeric(1)}\cr
Value that should be returned if the measure is not defined for the input
(as described in the note). Default is \code{NaN}.}

\item{...}{:: \code{any}\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Binary classification measure defined with \eqn{P} as \code{\link[=precision]{precision()}} and \eqn{R} as
\code{\link[=recall]{recall()}} as \deqn{
   (1 + \beta^2) \frac{P \cdot R}{(\beta^2 P) + R}.
}{
   (1 + beta^2) * (P*R) / ((beta^2 * P) + R).
}
It measures the effectiveness of retrieval with respect to a user who attaches \eqn{\beta}{beta} times
as much importance to recall as precision.
For \eqn{\beta = 1}{beta = 1}, this measure is called "F1" score.
}
\note{
This measure is undefined if
\itemize{
\item TP = 0
\item \link{precision} or \link{recall} is undefined, i.e. TP + FP = 0 or TP + FN = 0.
}
}
\section{Meta Information}{

\itemize{
\item Type: \code{"binary"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
lvls = c("a", "b")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
response = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
fbeta(truth, response, positive = "a")
}
\references{
Rijsbergen, Van CJ (1979).
\emph{Information Retrieval}, 2nd edition.
Butterworth-Heinemann, Newton, MA, USA.
ISBN 408709294.
Sasaki, Yutaka, others (2007).
\dQuote{The truth of the F-measure.}
\emph{Teach Tutor mater}, \bold{1}(5), 1--5.
\url{https://www.cs.odu.edu/~mukka/cs795sum10dm/Lecturenotes/Day3/F-measure-YS-26Oct07.pdf}.
}
\seealso{
Other Binary Classification Measures: 
\code{\link{auc}()},
\code{\link{bbrier}()},
\code{\link{dor}()},
\code{\link{fdr}()},
\code{\link{fnr}()},
\code{\link{fn}()},
\code{\link{fomr}()},
\code{\link{fpr}()},
\code{\link{fp}()},
\code{\link{mcc}()},
\code{\link{npv}()},
\code{\link{ppv}()},
\code{\link{prauc}()},
\code{\link{tnr}()},
\code{\link{tn}()},
\code{\link{tpr}()},
\code{\link{tp}()}
}
\concept{Binary Classification Measures}
\concept{binary_classification_measure}
