% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpDateFeatures.R
\name{mlr_pipeops_datefeatures}
\alias{mlr_pipeops_datefeatures}
\alias{PipeOpDateFeatures}
\title{Preprocess Date Features}
\format{
\code{\link{R6Class}} object inheriting from \code{\link{PipeOpTaskPreprocSimple}}/\code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}
\description{
Based on \code{POSIXct} columns of the data, a set of date related features is computed and added to
the feature set of the output task. If no \code{POSIXct} column is found, the original task is
returned unaltered. This functionality is based on the \code{add_datepart()} and
\code{add_cyclic_datepart()} functions from the \code{fastai} library. If operation on only particular
\code{POSIXct} columns is requested, use the \code{affect_columns} parameter inherited from
\code{\link{PipeOpTaskPreprocSimple}}.

If \code{cyclic = TRUE}, cyclic features are computed for the features \code{"month"}, \code{"week_of_year"},
\code{"day_of_year"}, \code{"day_of_month"}, \code{"day_of_week"}, \code{"hour"}, \code{"minute"} and \code{"second"}. This
means that for each feature \code{x}, two additional features are computed, namely the sine and cosine
transformation of \code{2 * pi * x / max_x} (here \code{max_x} is the largest possible value the feature
could take on \code{+ 1}, assuming the lowest possible value is given by 0, e.g., for hours from 0 to
23, this is 24). This is useful to respect the cyclical nature of features such as seconds, i.e.,
second 21 and second 22 are one second apart, but so are second 60 and second 1 of the next
minute.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpDateFeatures$new(id = "datefeatures", param_vals = list())
}\if{html}{\out{</div>}}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"datefeatures"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise
be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpTaskPreprocSimple}}.

The output is the input \code{\link[mlr3:Task]{Task}} with date-related features computed and added to the
feature set of the output task and the \code{POSIXct} columns of the data removed from the
feature set (depending on the value of \code{keep_date_var}).
}

\section{State}{

The \verb{$state} is a named \code{list} with the \verb{$state} elements inherited from
\code{\link{PipeOpTaskPreprocSimple}}.
}

\section{Parameters}{

The parameters are the parameters inherited from \code{\link{PipeOpTaskPreprocSimple}}, as well as:
\itemize{
\item \code{keep_date_var} :: \code{logical(1)}\cr
Should the \code{POSIXct} columns be kept as features? Default FALSE.
\item \code{cyclic} :: \code{logical(1)}\cr
Should cyclic features be computed? See Internals. Default FALSE.
\item \code{year} :: \code{logical(1)}\cr
Should the year be extracted as a feature? Default TRUE.
\item \code{month} :: \code{logical(1)}\cr
Should the month be extracted as a feature? Default TRUE.
\item \code{week_of_year} :: \code{logical(1)}\cr
Should the week of the year be extracted as a feature? Default TRUE.
\item \code{day_of_year} :: \code{logical(1)}\cr
Should the day of the year be extracted as a feature? Default TRUE.
\item \code{day_of_month} :: \code{logical(1)}\cr
Should the day of the month be extracted as a feature? Default TRUE.
\item \code{day_of_week} :: \code{logical(1)}\cr
Should the day of the week be extracted as a feature? Default TRUE.
\item \code{hour} :: \code{logical(1)}\cr
Should the hour be extracted as a feature? Default TRUE.
\item \code{minute} :: \code{logical(1)}\cr
Should the minute be extracted as a feature? Default TRUE.
\item \code{second} :: \code{logical(1)}\cr
Should the second be extracted as a feature? Default TRUE.
\item \code{is_day} :: \code{logical(1)}\cr
Should a feature be extracted indicating whether it is day time (06:00am - 08:00pm)?
Default TRUE.
}
}

\section{Internals}{

The cyclic feature transformation always assumes that values range from 0, so some values
(e.g. day of the month) are shifted before sine/cosine transform.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOpTaskPreprocSimple}}/\code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}

\section{Fields}{

Only fields inherited from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}

\examples{
library("mlr3")
dat = iris
set.seed(1)
dat$date = sample(seq(as.POSIXct("2020-02-01"), to = as.POSIXct("2020-02-29"), by = "hour"),
 size = 150L)
task = TaskClassif$new("iris_date", backend = dat, target = "Species")
pop = po("datefeatures", param_vals = list(cyclic = FALSE, minute = FALSE, second = FALSE))
pop$train(list(task))
pop$state
}
\seealso{
https://mlr3book.mlr-org.com/list-pipeops.html

Other PipeOps: 
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOp}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}},
\code{\link{mlr_pipeops}}
}
\concept{PipeOps}
