% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvGrafSE.R
\name{MeasureSurvGrafSE}
\alias{MeasureSurvGrafSE}
\alias{mlr_measures_surv.grafSE}
\title{Standard Error of Integrated Graf Score Survival Measure}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \code{MeasureSurvIntegrated}/\link{MeasureSurv}.}
\description{


Calculates the standard error of \link{MeasureSurvGraf}.

If \code{integrated == FALSE} then the standard error of the loss, L, is approximated via,
\deqn{se(L) = sd(L)/\sqrt{N}}{se(L) = sd(L)/\sqrt N}
where \eqn{N} are the number of observations in the test set, and \eqn{sd} is the standard deviation.

If \code{integrated == TRUE} then correlations between time-points need to be taken into account, therefore
\deqn{se(L) = \sqrt{\frac{\sum_{i = 1}^M\sum_{j=1}^M \Sigma_{i,j}}{NT^2}}}{se(L) = \sqrt((\sum_{i = 1}^M\sum_{j=1}^M cov(T_i, T_j)) / (NT^2))}
where \eqn{\Sigma_{i, j}}{cov(T_i, T_j)} is the sample covariance matrix over \eqn{M} distinct time-points.
}
\section{Construction}{
\preformatted{MeasureSurvGrafSE$new(integrated = TRUE, times)
mlr_measures$get("surv.grafSE")
msr("surv.grafSE")
}
\itemize{
\item \code{integrated} :: \code{logical(1)} \cr If \code{TRUE} (default), returns the integrated score; otherwise, not integrated. \cr
\item \code{times} :: \code{vector()} \cr If \code{integrate == TRUE} then a vector of time-points over which to integrate the score. If \code{integrate == FALSE} then a single time point at which to return the score. \cr
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{TRUE}
\item Required prediction: \code{distr}
}
}

\section{Fields}{

See \link{MeasureSurv}, as well as all variables passed to the constructor.
}

\references{
Graf, E., Schmoor, C., Sauerbrei, W. and Schumacher, M. (1999).\cr
Assessment and comparison of prognostic classification schemes for survival data.\cr
Statistics in Medicine, 18(17), 2529-2545.\cr
\doi{10.1002/(SICI)1097-0258(19990915/30)18:17/18<2529::AID-SIM274>3.0.CO;2-5}
}
\seealso{
Other survival measures: 
\code{\link{MeasureSurvBeggC}},
\code{\link{MeasureSurvChamblessAUC}},
\code{\link{MeasureSurvGonenC}},
\code{\link{MeasureSurvGraf}},
\code{\link{MeasureSurvHarrellC}},
\code{\link{MeasureSurvHungAUC}},
\code{\link{MeasureSurvIntLoglossSE}},
\code{\link{MeasureSurvIntLogloss}},
\code{\link{MeasureSurvLoglossSE}},
\code{\link{MeasureSurvLogloss}},
\code{\link{MeasureSurvNagelkR2}},
\code{\link{MeasureSurvOQuigleyR2}},
\code{\link{MeasureSurvSongAUC}},
\code{\link{MeasureSurvSongTNR}},
\code{\link{MeasureSurvSongTPR}},
\code{\link{MeasureSurvUnoAUC}},
\code{\link{MeasureSurvUnoC}},
\code{\link{MeasureSurvUnoTNR}},
\code{\link{MeasureSurvUnoTPR}},
\code{\link{MeasureSurvXuR2}}

Other Probabilistic survival measures: 
\code{\link{MeasureSurvGraf}},
\code{\link{MeasureSurvIntLoglossSE}},
\code{\link{MeasureSurvIntLogloss}},
\code{\link{MeasureSurvLoglossSE}},
\code{\link{MeasureSurvLogloss}}
}
\concept{Probabilistic survival measures}
\concept{survival measures}
