% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_prediction_surv.R
\name{as_prediction_surv}
\alias{as_prediction_surv}
\alias{as_prediction_surv.PredictionSurv}
\alias{as_prediction_surv.data.frame}
\title{Convert to a Survival Prediction}
\usage{
as_prediction_surv(x, ...)

\method{as_prediction_surv}{PredictionSurv}(x, ...)

\method{as_prediction_surv}{data.frame}(x, ...)
}
\arguments{
\item{x}{(\code{any})\cr
Object to convert.}

\item{...}{(\code{any})\cr
Additional arguments.}
}
\value{
\link{PredictionSurv}.
}
\description{
Convert object to a \link{PredictionSurv}.
}
\examples{
library(mlr3)
task = tsk("rats")
learner = lrn("surv.coxph")
learner$train(task)
p = learner$predict(task)

# convert to a data.table
tab = as.data.table(p)

# convert back to a Prediction
as_prediction_surv(tab)
}
