% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{auto_tuner}
\alias{auto_tuner}
\title{Syntactic Sugar for Automatic Tuning}
\usage{
auto_tuner(
  method,
  learner,
  resampling,
  measure,
  term_evals = NULL,
  term_time = NULL,
  search_space = NULL,
  ...
)
}
\arguments{
\item{method}{(\code{character(1)})\cr
Key to retrieve tuner from \link{mlr_tuners} dictionary.}

\item{learner}{(\link[mlr3:Learner]{mlr3::Learner}).}

\item{resampling}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Uninstantiated resamplings are instantiated during construction
so that all configurations are evaluated on the same data splits.}

\item{measure}{(\link[mlr3:Measure]{mlr3::Measure})\cr
Measure to optimize.}

\item{term_evals}{(\code{integer(1)})\cr
Number of allowed evaluations.}

\item{term_time}{(\code{integer(1)})\cr
Maximum allowed time in seconds.}

\item{search_space}{(\link[paradox:ParamSet]{paradox::ParamSet}).}

\item{...}{(named \code{list()})\cr
Named arguments to be set as parameters of the tuner.}
}
\value{
\link{AutoTuner}
}
\description{
Function to create an \link{AutoTuner} object.
}
\examples{
learner = lrn("classif.rpart")
learner$param_set$values$minsplit = to_tune(1, 10)

at = auto_tuner(
  method = "random_search",
  learner = learner, 
  resampling = rsmp ("holdout"),
  measure = msr("classif.ce"), 
  term_evals = 50, 
  batch_size = 10)  

at$train(tsk("pima"))
}
